//
//  psCharstrings.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CFFPrivateDict;
@class GlobalSubrsIndex;
@class SubrsIndex;
@class GSFileData;
@class IndexedStrings;
@class GSFileData;
@class GSXMLWriter;
@class OTBasePen;

@interface ByteCodeBase : NSObject {
	NSArray * _operandEncoding;
	NSDictionary * _operators;
}
@property (readonly, nonatomic) NSDictionary * operators;
- (id) do_operator:(NSUInteger)b0 file:(NSData*)Data pos:(NSUInteger*) Pos;

//- (NSNumber*) read_byte:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_smallInt1:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_smallInt2:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_shortInt:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_longInt:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_fixed1616:(NSInteger) b0 file:(GSFileData*) file ;
//- (NSNumber*) read_realNumber:(NSInteger) b0 file:(GSFileData*) file ;
@end

@interface psT2CharString : ByteCodeBase {
	NSMutableArray * _program;
	NSData* _bytecode;
	CFFPrivateDict* _private;
	GlobalSubrsIndex* _globalSubrs;
	NSInteger _width;
}
@property (nonatomic, retain) NSMutableArray *program;
@property (nonatomic, retain) NSData* bytecode;
@property (nonatomic, retain) CFFPrivateDict *private;
@property (nonatomic, retain) GlobalSubrsIndex *globalSubrs;
@property (nonatomic, assign) NSInteger width;

- (id) initWithBytecode:(NSData*)ByteCode private:(CFFPrivateDict*)Private globalSubrs:(GlobalSubrsIndex*)GlobalSubrs ;
//- (id) initWithFile:(GSFileData*)File private:(PrivateDict*)Private  globalSubrs:(GlobalSubrsIndex*)GlobalSubrs ;
- (void) toXML:(GSXMLWriter*)Writer;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content;
- (BOOL) needsDecompilation;
@end

@interface psT1CharString : psT2CharString {}

@end

@interface psDictDecompiler : ByteCodeBase {
	//id _operators;
	IndexedStrings * _strings;
	NSMutableDictionary * _dict;
	NSMutableArray * _stack;
}
- (void) decompile:(NSData*) File ;
- (id) initWithStrings:(id)Strings ;
- (id) dict;
- (void) handleOperator:(NSString*)operator argType:(id)argType ;
@end


@interface psSimpleT2Decompiler : NSObject {
	SubrsIndex * _localSubrs;
	NSUInteger _localBias;
	GlobalSubrsIndex * _globalSubrs;
	NSUInteger _globalBias;
	NSMutableArray * _callingStack;
	NSMutableArray * _operandStack;
	NSUInteger _hintCount;
	NSUInteger _hintMaskBytes;
}
@property (nonatomic, retain) SubrsIndex * localSubrs;
@property (nonatomic) NSUInteger localBias;
@property (nonatomic, retain) id globalSubrs;
@property (nonatomic) NSUInteger globalBias;
@property (nonatomic, retain) NSMutableArray* callingStack;
- (void)addToCallingStack:(id)_callingStackObject;
- (void)removeFromCallingStack:(id)_callingStackObject;

@property (nonatomic, retain) NSMutableArray* operandStack;
@property (nonatomic) NSUInteger hintCount;
@property (nonatomic) NSUInteger hintMaskBytes;

- (id) initWithLocalSubrs:(SubrsIndex*)LocalSubrs globalSubrs:(GlobalSubrsIndex*)GlobalSubrs ;
- (void) execute:(psT2CharString*)Charstring;

@end


@interface psT2OutlineExtractor : psSimpleT2Decompiler {
	OTBasePen * _pen;
	NSUInteger _nominalWidthX;
	NSUInteger _defaultWidthX;
	NSMutableArray* _hints;
	BOOL _gotWidth;
	NSInteger _width;
	NSPoint _currentPoint;
	BOOL _sawMoveTo;
}
@property (nonatomic, retain) OTBasePen* pen;
@property (nonatomic, retain) NSMutableArray* hints;
@property (nonatomic) NSInteger width;
- (id) initWithPen:(OTBasePen*)Pen localSubrs:(SubrsIndex*)LocalSubrs globalSubrs:(GlobalSubrsIndex*)GlobalSubrs nominalWidthX:(int)NominalWidthX defaultWidthX:(int)DefaultWidthX ;
@end

@interface psT1OutlineExtractor : psT2OutlineExtractor {
	id _subrs;
	BOOL _flexing;
	int _sbx;
}
@property (nonatomic, retain) id subrs;
@property (nonatomic) BOOL flexing;
@property (nonatomic) int sbx;

@end
