//
//  table_O_S_2f_2.h
//  GSFontTools
//
//  Created by Georg Seifert on 09.11.12
//  Copyright 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OTTables.h"

// panose classification
//
typedef struct {
	uint8_t panoseFamilyType; //        B
	uint8_t panoseSerifStyle; //      B
	uint8_t panoseWeight; //          B
	uint8_t panoseProportion; //      B
	uint8_t panoseContrast; //        B
	uint8_t panoseStrokeVariation; // B
	uint8_t panoseArmStyle; //        B
	uint8_t panoseLetterForm; //      B
	uint8_t panoseMidline; //         B
	uint8_t panoseXHeight; //         B
} panoseFormat;

@interface table_O_S_2f_2 : BaseTTXConverter {
	uint16_t _version;
@public
	int16_t _xAvgCharWidth; //          h       // average character width
	uint16_t _usWeightClass; //          H       // degree of thickness of strokes
	uint16_t _usWidthClass; //           H       // aspect ratio
	int16_t _fsType; //                 h       // type flags
	int16_t _ySubscriptXSize; //        h       // subscript horizontal font size
	int16_t _ySubscriptYSize; //        h       // subscript vertical font size
	int16_t _ySubscriptXOffset; //      h       // subscript x offset
	int16_t _ySubscriptYOffset; //      h       // subscript y offset
	int16_t _ySuperscriptXSize; //      h       // superscript horizontal font size
	int16_t _ySuperscriptYSize; //      h       // superscript vertical font size
	int16_t _ySuperscriptXOffset; //    h       // superscript x offset
	int16_t _ySuperscriptYOffset; //    h       // superscript y offset
	int16_t _yStrikeoutSize; //         h       // strikeout size
	int16_t _yStrikeoutPosition; //     h       // strikeout position
	int16_t _sFamilyClass; //           h       // font family class and subclass
	uint8_t _panose[10];
	uint32_t _ulUnicodeRange1; //        L       // character range
	uint32_t _ulUnicodeRange2; //        L       // character range
	uint32_t _ulUnicodeRange3; //        L       // character range
	uint32_t _ulUnicodeRange4; //        L       // character range
	
	char _achVendID[4]; //              4s      // font vendor identification
	uint16_t _fsSelection; //            H       // font selection flags
	uint16_t _usFirstCharIndex; //       H       // first unicode character index
	uint16_t _usLastCharIndex; //        H       // last unicode character index
	int16_t _sTypoAscender; //          h       // typographic ascender
	int16_t _sTypoDescender; //         h       // typographic descender
	int16_t _sTypoLineGap; //           h       // typographic line gap
	uint16_t _usWinAscent; //            H       // Windows ascender
	uint16_t _usWinDescent; //           H       // Windows descender
	// /format 0
	
	uint32_t _ulCodePageRange1;  //  L
	uint32_t _ulCodePageRange2;  //  L
	// /format 1
	
	int16_t _sxHeight; //          h
	int16_t _sCapHeight; //        h
	int16_t _usDefaultChar; //     H
	int16_t _usBreakChar; //       H
	int16_t _usMaxContext; //       H
	// /format 2
	
	int16_t	_usLowerOpticalPointSize;
	int16_t	_usUpperOpticalPointSize;
	// format 5
}
@property (nonatomic, assign) uint16_t version;
@end
