//
//  table__n_a_m_e.h
//  GSFontTools
//
//  Created by Georg Seifert on 25.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"
@class TTNameRecord;
typedef struct {
// big endian
	uint16_t platformID;
	uint16_t platEncID;
	uint16_t langID;
	uint16_t nameID;
	uint16_t length;
	uint16_t offset;
} nameRecordFormat;

@interface table__n_a_m_e : TTable {
	NSMutableArray * _names;
}
@property (retain, nonatomic) NSMutableArray * names;
- (NSArray*) namesForId:(uint16_t) NameID;
- (NSArray*) sortedNameRecordsForId:(uint16_t) NameID;
- (TTNameRecord*) nameForNameID:(uint16_t)NameID platformID:(uint16_t)PlatformID platEncID:(uint16_t)PlatEncID langID:(uint16_t)LangID;
- (NSString*) bestNameForId:(uint16_t) NameID;
- (NSUInteger)addName:(NSString*)Name;
@end

@interface TTNameRecord : NSObject {
	uint16_t _nameID;
	uint16_t _platformID;
	uint16_t _platEncID;
	uint16_t _langID;
	NSString * _string;
	NSData * _data;
}
@property (nonatomic) uint16_t nameID;
@property (nonatomic) uint16_t platformID;
@property (nonatomic) uint16_t platEncID;
@property (nonatomic) uint16_t langID;
@property (retain, nonatomic) NSString * string;
@property (retain, nonatomic) NSData * data;

- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font ;

@end
