/// /// /// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ///
//
//	SEQOY™ Development and Consulting
//	http://www.seqoy.com
//
///////////////
//
//	History:
//
//	19/12/08 --- Created by Matt Gallagher (http://cocoawithlove.com/)
//	20/09/09 --- Several changes by Paulo Oliveira
//
//	OTOrderedDictionary.h 
// 
/// /// /// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ///
//
//  Permission is given to use this source code file without charge in any
//  project, commercial or otherwise, entirely at your risk, with the condition
//  that any redistribution (in part or whole) of source code must retain
//  this copyright and permission notice. Attribution in compiled projects is
//  appreciated but not required.
//
/// /// /// ////// ////// ////// ////// ////// ////// //
#import <Foundation/Foundation.h> 

@interface OTOrderedDictionary : NSDictionary <NSCopying>
{
	NSMutableDictionary *dictionary;
	NSMutableArray *array;
}

//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// 
#pragma mark -

#pragma mark Init Methods. 
- (id) initWithCapacity:(NSUInteger)capacity;

- (id) initWithDictionary:(NSDictionary*)anObject ;

- (id) initWithObjects:(NSArray*)Objects forKeys:(NSArray*)Keys;

- (id) initWithObject:(NSMutableDictionary*)anObject withArray:(NSMutableArray*)anArray;

/// This method is similar to initWithDictionary, the difference is: This method will Scan the all Dictionary tree converting internal elements too.

- (id) initConvertFromDictionary:(id)anObject;

- (instancetype)initWithObjectsAndKeys:(id)firstObject, ... NS_REQUIRES_NIL_TERMINATION;

+ (instancetype)dictionaryWithKeysAndObjects:(id)firstObject, ... NS_REQUIRES_NIL_TERMINATION;
#pragma mark -
#pragma mark Sorting Methods. 

/// Reorder the Dictionary using one giving function.
- (void)sortUsingFunction:(NSInteger (*)(id, id, void*))comparator context:(void*)context;

- (void)sortUsingSelector:(SEL)Comparator ;

#pragma mark -
#pragma mark Insert Methods. 
- (id)objectForKey:(id)aKey;
- (NSArray*)allKeys;
//- (NSArray*)allValues;
- (void)setObject:(id)anObject forKey:(id)aKey;

- (void)insertObject:(id)anObject forKey:(id)aKey atIndex:(NSUInteger)anIndex;

- (void)addEntriesFromDictionary:(NSDictionary*)otherDictionary;
#pragma mark -
#pragma mark Remove Methods. 

- (void)removeLastObject;

- (void)removeObjectForKey:(id)aKey;

- (void)removeObjectAtIndex:(NSUInteger)anIndex;  

- (BOOL)removeObjectFromIndex:(NSUInteger)from To:(NSUInteger)to;	// This method could be slow on large dictionaries.

- (void)removeObjectsInRange:(NSRange)aRange; // This method could be slow on large dictionaries.

- (void)removeObjectsForKeys:(NSArray*)keyArray ;
//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// 
#pragma mark -
//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// 
#pragma mark Retrieve Methods. 

- (id)objectAtIndex:(NSUInteger)anIndex;

- (NSUInteger)indexOfKey:(id)aKey;

- (id)keyAtIndex:(NSUInteger)anIndex;

#pragma mark Manipulate Methods. 

- (void)swipeIndex:(NSUInteger)from with:(NSUInteger)to; 

- (void)exchangeObjectAtIndex:(NSUInteger)idx1 withObjectAtIndex:(NSUInteger)idx2; 	// This is the same of swipeIndex, this method is just for compatibility.

- (void)moveFromIndex:(NSUInteger)from To:(NSUInteger)to; 

- (NSEnumerator*)reverseKeyEnumerator;

- (id)objectForKeyedSubscript:(id)aKey;

- (void)setObject:(id)anObject forKeyedSubscript:(id)aKey;

@end
