//
//  table__f_v_a_r.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.08.16.
//  Copyright 2016 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"

@interface table__f_v_a_r : TTable {}

@property (nonatomic) int32_t version; //:        L
@property (nonatomic) u_int16_t offsetToData; //:   H
@property (nonatomic) u_int16_t countSizePairs; //: H
@property (nonatomic) u_int16_t axisCount; //:      H
@property (nonatomic) u_int16_t axisSize; //:       H
@property (nonatomic) u_int16_t instanceCount; //:  H
@property (nonatomic) u_int16_t instanceSize; //:   H


@property (nonatomic, strong) NSMutableArray *axes;
@property (nonatomic, strong) NSMutableArray *instances;
- (NSArray*)axisTags;
@end

@interface GXAxis : NSObject {}

@property (nonatomic, strong) NSString *axisTag;
@property (nonatomic) uint16_t nameID;
@property (nonatomic) uint16_t flags; // not exposed in XML because spec defines no values
@property (nonatomic) CGFloat minValue; // -1.0
@property (nonatomic) CGFloat defaultValue; //  0.0
@property (nonatomic) CGFloat maxValue; // 1.0
- (instancetype)initWithTag:(NSString*)axisTag min:(CGFloat)minValue default:(CGFloat)defaultValue max:(CGFloat)maxValue;
- (BOOL) decompile:(NSData*)Data pos:(NSUInteger*)pos error:(NSError**)error;
- (BOOL) compile:(NSMutableData*)Data error:(NSError**)error;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font;
@end

@interface GXNamedInstance : NSObject {}
@property (nonatomic, strong) NSString *name; // 0
@property (nonatomic) uint16_t nameID; // min 256
@property (nonatomic) uint16_t flags; // 0  # not exposed in XML because spec defines no values
@property (nonatomic, strong) NSMutableDictionary* coordinates;
@property (nonatomic) uint16_t postscriptNameID;

- (BOOL) decompile:(NSData*)Data axisTags:(NSArray*)axisTags error:(NSError**)error;
- (BOOL) compile:(NSMutableData*)Data axisTags:(NSArray*)axisTags error:(NSError**)error;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font;
@end
