//
//  table__g_l_y_f.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.03.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TTable.h"

@class OTOrderedDictionary;
@class GSFileData;
@class Glyph_g_l_y_f;
@class TTProgram;
@class FTPointArray;
@class GSIntArray;

typedef enum : u_int8_t {
	TTGlyfFlagOnCurve = 0x01,
	TTGlyfFlagXShort = 0x02,
	TTGlyfFlagYShort = 0x04,
	TTGlyfFlagRepeat = 0x08,
	TTGlyfFlagXsame =  0x10,
	TTGlyfFlagYsame = 0x20
} TTGlyfFlags;


@interface table__g_l_y_f : TTable 
@property (nonatomic, retain) OTOrderedDictionary *glyphs;

- (NSUInteger) countOfGlyphs;
- (NSString*) glyphNameAtIndex:(NSUInteger) GlyphID ;
- (NSUInteger) indexOfGlyphName:(NSString*) GlyphName ;
- (Glyph_g_l_y_f*) glyphAtIndex:(NSUInteger) GlyphID ;
- (Glyph_g_l_y_f*) glyphForName:(NSString*) GlyphName ;
- (void) addGlyph:(Glyph_g_l_y_f*) Glyph forKey:(NSString*) GlyphName ;

@end

/*
@interface TTNode : NSObject {
	NSPoint _position;
	u_int8_t _flags;
}
@property (nonatomic, assign) NSPoint position;
@property (nonatomic, assign) u_int8_t flags;
@end
*/

@interface Glyph_g_l_y_f : NSObject {
	NSData * _data;
	short _numberOfContours;
	FTPointArray *_coordinates;
	NSMutableArray * _components;
	GSIntArray * _endPtsOfContours;
	GSIntArray * _flags;
	NSRect _bounds;
	NSUInteger _width;
	TTProgram * _program;
	NSString *_name;
}
@property (nonatomic, retain) NSData *data;
@property (nonatomic) short numberOfContours;
@property (nonatomic, retain) FTPointArray *coordinates;
@property (nonatomic, retain) NSMutableArray *components;
@property (nonatomic, retain) TTProgram *program;
@property (nonatomic, retain) GSIntArray *endPtsOfContours;
@property (nonatomic, retain) GSIntArray *flags;
@property (nonatomic, assign) NSRect bounds;
@property (nonatomic, assign) NSUInteger width;
@property (nonatomic, retain) NSString *name;

- (id) initWithData:(NSData*) Data ;
- (NSData*) compile:(id)glyfTable recalcBBoxes:(BOOL)RecalcBBoxes error:(NSError **)error ;
- (void) expand:(table__g_l_y_f*) glyfTable;
- (void) decompileComponents:(NSData*) Data glyfTable:(table__g_l_y_f*)glyfTable;
- (BOOL) isComposite;
@end



@interface GlyphComponent_g_l_y_f : NSObject {
	NSAffineTransformStruct _transformStruct;
	NSString * _glyphName;
	BOOL _haveInstructions;
	BOOL _more;
	u_int16_t _flags;
	u_int16_t _glyphID;
	NSUInteger _firstPt;
	NSUInteger _secondPt;
}
@property (nonatomic, retain) NSString *glyphName;
@property (nonatomic, assign) u_int16_t glyphID;
@property (nonatomic, assign) NSAffineTransformStruct transformStruct;
@property (nonatomic, assign) BOOL haveInstructions;
@property (nonatomic, assign) BOOL more;
@property (nonatomic, assign) u_int16_t flags;
@property (nonatomic, assign) NSUInteger firstPt;
@property (nonatomic, assign) NSUInteger secondPt;

- (BOOL) decompile:(GSFileData*) Data glyfTable:(table__g_l_y_f*)glyfTable;
- (NSData*) compileComponents:(table__g_l_y_f*)glyfTable more:(BOOL)More haveInstructions:(BOOL)haveInstructions error:(NSError**)error ;

@end
