//
//  GSCustomParameter.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.11.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSInstance;
@protocol GSContainerProtocol;

/** Implementation of the Custom Property object.

 It stores a name/value pair
 */

@interface GSCustomParameter : NSObject {
	NSString *_name;
	id _value;
}
- (instancetype)initWithName:(NSString *)Name value:(id)Value parent:(NSObject <GSContainerProtocol>*)Parent;

- (instancetype)initWithName:(NSString *)Name value:(id)Value;

@property (weak, nonatomic) NSObject <GSContainerProtocol> *parent;
@property (nonatomic, strong) NSString *name;
@property (nonatomic, strong) id value;

- (BOOL)saveToFile:(FILE *)File error:(NSError *__autoreleasing*)error;

+ (NSColor *)colorFromValue:(id)Value;
/** If the property stores a color, this returns a NSColor object
 
 It converts a comma separated list of strings into a color. e. g. 63,165,53 will be green
 @return a NSColor object
 */
- (NSColor *)colorValue;

- (id)propertyListValue;

- (NSString *)displayValue;

- (id)contentValue;

- (NSString *)stringValue;

- (BOOL)boolValue;

- (float)floatValue;

- (NSInteger)integerValue;

- (int)intValue;

- (CGFloat)localizedValueForScript:(NSString *)script;
@end

NSSet* getIncludeExcludeGlyphList(NSArray* Arguments, BOOL* Include);
