//
//  GSElement.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#if !__has_feature(nullability)
#define NS_ASSUME_NONNULL_BEGIN
#define NS_ASSUME_NONNULL_END
#define nullable
#define nonnull
#define null_unspecified
#define null_resettable
#define __nullable
#define __nonnull
#define __null_unspecified
#endif
NS_ASSUME_NONNULL_BEGIN

@class GSLayer;

/** GSElement: The base class for Layer elements.

 The base class for Layer elements.
 */

@interface GSElement : NSObject <NSCoding, NSCopying> {
	BOOL _locked;
@public
	id __unsafe_unretained _parent;
	NSPoint _position;
	NSPoint _positionPrecise;
}
/// The position of the element.
@property(assign, nonatomic) NSPoint position;

/** The unrounded position of the element.
 
 This is used for consecutiv operations to avoid rounding errors
 */
@property(nonatomic, readonly) NSPoint positionPrecise;

/** Sets the position without notifying the path and no undo.
 
 This is mostly used to build a new element list that is later added to the layer. Otherwise you need to make sure to anounce the changes. e.g. by calling `[GSLayer elementDidChange:]`.
 
 @param position The new position
 */

- (void)setPositionFast:(NSPoint)position;

- (void)setPositionFast:(NSPoint)position round:(CGFloat)Grid;

@property (nonatomic) BOOL locked;


- (void)makeUnlocked;

- (void)makeLocked;

/// Returns/sets the content of the element to store in pList. 
@property(unsafe_unretained, nonatomic, nullable) NSDictionary *elementDict;

/// A Pointer to the containing object
@property(unsafe_unretained, nonatomic, nullable) id parent;

- (GSLayer*)layer;
/** initialises a element with a dictionary loaded from a pList.

@param ElementDict A dictionary
*/
- (instancetype)initWithElementDict:(NSDictionary *)ElementDict;

#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File compact:(BOOL)Compact error:(NSError *__autoreleasing*)error;
- (BOOL)saveToFile:(FILE*)File error:(NSError *__autoreleasing*)error;

#endif

- (NSRect)getHandleRect:(NSPoint)pt scale:(CGFloat)Scale;

- (NSRect)bounds;
//- (void) drawInView:(id) View ;
- (BOOL)hitTest:(NSPoint)aPoint tollerance:(CGFloat)tollerance;
@end
NS_ASSUME_NONNULL_END
