/*! \file GSNode.h */
//
//  GSNode.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
#if !__has_feature(nullability)
#define NS_ASSUME_NONNULL_BEGIN
#define NS_ASSUME_NONNULL_END
#define nullable
#define nonnull
#define null_unspecified
#define null_resettable
#define __nullable
#define __nonnull
#define __null_unspecified
#endif
NS_ASSUME_NONNULL_BEGIN

/**
An enumeration of node and connection types.
*/
typedef NS_ENUM(uint8_t, GSNodeType) {
	/// Move
	MOVE = 17,
	/// Line
	LINE = 1,
	/// Curve
	CURVE = 35,
	/// Offcurve
	OFFCURVE = 65,
	QCURVE = 36,
	/// Sharp connection
	SHARP = 0,
	/// Smooth connection
	SMOOTH = 100,
	SPECIAL = 101
};

/** The class defining the node object

 It is a subclass of GSElement
 */
@interface GSNode : GSElement <NSCoding, NSCopying> {
	NSMutableDictionary* _userData;
@public
	GSNodeType _type;
	GSNodeType _connection;
}
/// node type
@property (assign, nonatomic) GSNodeType type;
/// connection type
@property (assign, nonatomic) GSNodeType connection;

- (void)setElementString:(NSString *)String;

- (CFStringRef)copyElementString;

- (instancetype)initWithElementString:(NSString*)ElementString;

/** toggles the connection type between SHARP and SMOOTH */
- (void)toggleConnection;

- (void)checkConnection;

/** Convenient method to make this the first node in the path.*/
- (void)makeNodeFirst;

@property (nonatomic, strong) NSMutableDictionary* userData;
- (id)userDataForKey:(NSString *)key;
- (void)setUserData:(id)value forKey:(NSString *)key;
- (void)removeUserDataForKey:(NSString *)key;
@end
NS_ASSUME_NONNULL_END