//
//  GSPath+PenDrawing.h
//  GlyphsCore
//
//  Created by Georg Seifert on 07.05.17.
//  Copyright © 2017 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSPath.h>
#import <GlyphsCore/GSPenProtocol.h>

@class GSHint;

@interface GSPath (PenDrawing)

/**
 Draws the path using a pen conforming to the GSPenProtocol
 
 @param pen A pen conforming to the GSPenProtocol
 */

- (void)drawInPen:(NSObject<GSPenProtocol>*_Nonnull)pen;

- (void)drawInPen:(NSObject<GSPenProtocol>*_Nonnull)pen secondaryPen:(NSObject<GSPenProtocol>* _Nullable)secondPen;

- (void)drawSimpleInPen:(NSObject<GSPenProtocol>*_Nonnull)pen;

- (BOOL)decomposeCorner:(GSHint*_Nonnull)corner;

@end
