//
//  GSPathSegment.h
//  PathOperations
//
//  Created by Georg Seifert on 03.03.14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//


typedef struct {
	NSPoint elements[4];
	uint8 count;
	uint8 type;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
} GSSegmentStruct;

void _GSSegmentUpdateBounds(GSSegmentStruct*S);

@interface GSPathSegment : NSObject <NSCopying> {
	
@public
	NSPoint elements[40];
	uint8 type;
	uint8 count;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
}
- (instancetype) initWithLinePoint1:(NSPoint)P1 point2:(NSPoint)P2 direction:(BOOL) Black;
- (instancetype) initWithCurvePoint1:(NSPoint)P1 point2:(NSPoint)P2 point3:(NSPoint)P3 point4:(NSPoint)P4 direction:(BOOL) Black;
- (instancetype) initWithDescription:(NSString*)string;
- (instancetype) initWithQCurve:(NSArray *)Points;
- (instancetype) initWithQCurve:(NSPoint *)Points count:(int)Count;
- (instancetype) initWithSegmentStruct:(GSSegmentStruct*)S ;
- (GSSegmentStruct)segmentStruct ;
- (void) updateBounds;
- (void) reverse;
- (NSComparisonResult) compare:(GSPathSegment*) otherObject;
- (BOOL) isEqualToSegment:(GSPathSegment*) otherSegment;
- (NSPoint) middlePoint;
- (NSPoint) middlePointRight;
- (NSPoint) middlePointLeft;
- (void) splitFirstHalf:(GSPathSegment**)left secondHalf:(GSPathSegment**)right;
- (bool) intersects:(GSPathSegment*) OtherSegment;
- (double**) intersections:(GSPathSegment*) OtherSegment NS_RETURNS_INNER_POINTER;
@end
