//
//  GSSubstitution.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface GSSubstitution : NSObject <NSCoding, NSCopying> {
	NSString* _back;
	NSString* _source;
	NSString* _fwd;
	NSString* _target;
	NSString* _backString;
	NSString* _sourceString;
	NSString* _fwdString;
	NSString* _targetString;
	BOOL _ignore;
	NSString* _languageTag;
	NSString* _scriptTag;
}
//! Context glyphs (as glyph names) before the source.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString* back;
//! The source  glyphs.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString* source;
//! Context glyphs after the source.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString* fwd;
//! The target glyphs.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString* target;
// Context glyphs before the source.
/*
 As char string. This is set internaly.
 */
@property (strong, nonatomic) NSString* backString;
// The source glyphs.
/*
 As char string. This is set internaly.
 */
@property (strong, nonatomic) NSString* sourceString;
// Context glyphs after the source.
/*
 As char string. This is set internaly.
 */
@property (strong, nonatomic) NSString* fwdString;
// The target glyphs.
/*
 As char string. This is set internaly.
 */
@property (strong, nonatomic) NSString* targetString;

//! ignore this substitution.
@property (nonatomic) BOOL ignore;
//! the language tag.
@property (strong, nonatomic) NSString* languageTag;
@property (strong, nonatomic) NSString* scriptTag;

//! Init with dictionary loaded from pList.
- (instancetype)initWithDict:(NSDictionary*)Dict;

//! Init with String in OT syntax.
- (instancetype)initWithCode:(NSString*)Code;

//! Returns a dictionary to store in pList.
//- (GSSubstitution*) substitutionForFont:(GSFont*) Font source:(NSString*) Source target:(NSString*) Target ;
- (NSDictionary*)substDict;

//! The substitution representation on FDK syntax.
- (NSString*)code;
@end
