//
//  GSAlignmentZone.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#if !__has_feature(nullability)
#define NS_ASSUME_NONNULL_BEGIN
#define NS_ASSUME_NONNULL_END
#define nullable
#define nonnull
#define null_unspecified
#define null_resettable
#define __nullable
#define __nonnull
#define __null_unspecified
#endif
NS_ASSUME_NONNULL_BEGIN
@class GSFontMaster;

@interface GSAlignmentZone : NSObject {
	GSFontMaster* __unsafe_unretained _parent;
	NSString* _name;
	NSInteger _position;
	NSInteger _size;
	NSPredicate* _filter;
	NSDictionary* _options;
}
@property (nonatomic, strong, nullable) NSString* name;
@property (nonatomic) NSInteger position;
@property (nonatomic) NSInteger size;
@property (unsafe_unretained, nonatomic, nullable) GSFontMaster* parent;
@property (nonatomic, retain, nullable) NSPredicate* filter;
@property (nonatomic, retain, nullable) NSDictionary* options;

- (instancetype)initWithElementString:(NSString*)String;

- (instancetype)initWithElementDict:(NSDictionary*)Dict;

- (NSString*)elementString;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE*)File error:(NSError *__autoreleasing*)error;

#if 0
- (void)addScript:(id)aScript;

- (void)removeScript:(id)aScript;

- (NSUInteger)countOfScripts;

//- (void)getScripts:(id*)buffer range:(NSRange)inRange;
- (id)objectInScriptsAtIndex:(NSUInteger)idx;

- (void)insertObject:(NSMutableDictionary*)aNSMutableDictionary inScriptsAtIndex:(NSUInteger)idx;

//- (void)insertScripts:(NSArray*)_scriptArray atIndexes:(NSIndexSet*)indexes;

- (void)removeObjectFromScriptsAtIndex:(NSUInteger)idx;

- (void)removeScriptsAtIndexes:(NSIndexSet*)indexes;

- (void)replaceObjectInScriptsAtIndex:(NSUInteger)idx withObject:(NSMutableDictionary*)aNSMutableDictionary;

- (void)replaceScriptsAtIndexes:(NSIndexSet*)indexes withScripts:(NSArray*)_scriptArray;
#endif

- (id)propertyListValue;
#endif
@end
NS_ASSUME_NONNULL_END