//
//  GSClass.h
//  GlyphsCore
//
//  Created by Georg Seifert on 25.10.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;
/**
 The class represents the OpenType classes
 */
@interface GSClass : NSObject <NSCoding, NSCopying> {
	GSFont* __unsafe_unretained _parent;
	NSString* _name;
	NSString* _code;
	BOOL _automatic;
	BOOL _disabled;
	NSString* _notes;
	NSString* _predicate;
}
/**
 a reference to the font contaning the class
 */
@property (nonatomic, unsafe_unretained) GSFont* parent;

/**
 The name of the class
 */
@property (nonatomic, copy) NSString* name;

/**
 The content of the class
 
 Normally glyph names seperated my spaces.
 */
@property (strong, nonatomic) NSString* code;

- (NSString *)saveCode;
/**
 if the class is replaced on automatic feature generation.
 */
@property (nonatomic) BOOL automatic;

@property (nonatomic, strong) NSString *predicate;

/** If True, the feature will not be exported. */
@property (nonatomic) BOOL disabled;

/**
 Some notes for the class.
 */
@property (nonatomic, strong) NSString* notes;
@property (nonatomic, unsafe_unretained) NSDictionary* classDict;
#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File error:(NSError *__autoreleasing*)error escape:(BOOL)escape;

/**
 Triggers the regeneration of the class.
 */
- (void)update;
#endif
@end
