//
//  GSGlyphsInfo+FeatureGenerator.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.09.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//
@class GSFont;

#define AutomaticCodeStart @"# Automatic Code Start"
#define AutomaticCodeEnd @"# Automatic Code End"

/**
 Generates the OT features for the Font.
 */
@interface GSFeatureGenerator : NSObject {
	int _defaultFigures;
	NSDictionary *_commonLigs;
	NSDictionary *_nonCombiningFeatures;
@private
	NSArray* _scripts;
}

/**
 This retunes the feature genrator object.
 
 @return This is always the same object
 */
+ (GSFeatureGenerator*)sharedManager;

/** resets the generator to a clean state. Call that between generation for different fonts */
- (void)reset;
/** Generates all default features
 
 This equivalent with pressing the Update button in font info
 
 @param Font a font
 @see updateFeatureForTag:forFont:
 */
- (void)makeFeatures:(GSFont*)Font;

/** Updates a particular feature

 If the Feature is not there, it will be added
 
 @param Tag  The Feature tag for the feature that should be updated
 @param Font The font object that contains the feature
 */
- (void)updateFeatureForTag:(NSString*)Tag forFont:(GSFont*)Font;

/** Updates a particular class
 
 This cold be the @Uppercase class
 
 @param Tag  The name for the class that should be updated
 @param Font The font object that contains the class
 */
- (void)updateClassForTag:(NSString*)Tag forFont:(GSFont*)Font;

/** Updates a particular prefix
 
 @param Tag  The name for the prefix that should be updated
 @param Font The font object that contains the prefix
 */
- (void)updatePrefixForTag:(NSString*)Tag forFont:(GSFont*)Font;

+ (NSDictionary*)nonCombiningFeatures;

+ (NSString*)cleanMakeOTFErrormessage:(NSString*)ErrorMessage errorDescriptors:(NSMutableArray*)ErrorDescriptors path:(NSString*)Path;

+ (NSArray*)devaLanguages:(GSFont*)Font;
@end
