//
//  GSGlyphInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief GSGlyphInfo: The class defining the glyphinfo object
 \ingroup common
 This class defines the glyphinfo object.
 */
@interface GSGlyphInfo : NSObject <NSCopying> {
	NSString* _unicharString;
@public
	NSString* name;
	NSString* category;
	NSString* subCategory;
	NSArray* components;
	NSArray* accents;
	NSArray* anchors;
	NSString* unicode;
	NSString* unicode2;
	NSString* script;
	NSString* production;
	NSUInteger index;
	NSString* sortName;
	NSString* sortNameKeep;
	NSArray* altNames;
}
//! The glyph name.
@property (strong, nonatomic) NSString* name;
//! The category of the glyph.
/**
This is mostly from the UnicodeData.txt file from unicode.org. Some corrections have been made (Accents, ...)
e.g: "Letter", "Number", "Punctuation", "Mark", "Separator", "Symbol", "Other"
*/
@property (strong, nonatomic) NSString* category;

//! The subcategory of the glyph.
/**
This is mostly from the UnicodeData.txt file from unicode.org. Some corrections and additions have been made (Smallcaps, ...)
e.g: "Uppercase", "Lowercase", "Smallcaps", "Ligature", "Decimal Digit", ...
*/
@property (strong, nonatomic) NSString* subCategory;

//! The Glyph is composed from this glyphs.
/**
f_f_i > f f i
Adieresis > A dieresis
*/
@property (strong, nonatomic) NSArray* components;

@property (strong, nonatomic) NSArray* baseGlyphs;
//! The Glyph can ba combined with this accents.
/**
a > dieresis, grave, acute ...
*/
@property (strong, nonatomic) NSArray* accents;

//! The anchors of the glyph.
/**
e.g: "top", "ogonek"
*/
@property (strong, nonatomic) NSArray* anchors;

//! The unicode value.
/**
as a hex string.
*/
@property (strong, nonatomic) NSString* unicode;
//! The second unicode value.
/**
as a hex string.
*/
@property (strong, nonatomic) NSString* unicode2;

@property (readonly, nonatomic) NSString *unicharString;
//! The script.
/**
e.g: "Latin", "Cyrillic", "Greek"
*/
@property (strong, nonatomic) NSString* script;

//! Name to use on export
/**
acyrill > afii10065
*/
@property (strong, nonatomic) NSString* production;
@property (nonatomic) NSUInteger index;
@property (strong, nonatomic) NSString* sortName;
@property (strong, nonatomic) NSString* sortNameKeep;
@property (strong, nonatomic) NSString* desc;
@property (nonatomic, strong) NSArray* altNames;

- (NSString*)componentsString;

#if DEBUG

- (id)initWithLine:(NSString*)Line;

- (NSString*)line;
#endif
@end
