//
//  GSGlyphViewControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 11.09.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSLayer;
#import <GlyphsCore/GSFont.h>
#import <GlyphsCore/GSGlyphEditViewProtocol.h>

/** This protocol defines the API for the main view controllers. This is implemented by the font view controller and the edit view controller.
 */

@protocol GSGlyphViewControllerProtocol

/// The index of the active master
@property (nonatomic) NSUInteger masterIndex;

/// The selected layers
@property (readonly, nonatomic) NSArray* selectedLayers;

/// The GSFont object
@property (readonly, nonatomic) id representedObject;

/** The active layer
 
 If only one layer is selected it retunes it, otherwise it retunes nil.
 
 In the editview, this is the layer that has a gray info box.
 */
@property (readonly, nonatomic) GSLayer* activeLayer;

/** This is a copy of the layer while and drag operation or a filter dialog is active.
 
 It stores the original content objects of the layer, so please don’t change anything
 */
@property (strong, nonatomic) GSLayer* shadowLayer;

- (NSView*)contentView;

@property (nonatomic) CGFloat scale;

@optional
/** is called to determine if the "Show Info for Selection" menu item should be activated
 
 @return a bool
 */
- (BOOL)canShowInfoForSelection;
/** This is the action for the "Show Info for Selection" menu item.
 
 @param sender The caller, most likly the menu item
 */
- (IBAction)showInfoForSelection:(id)sender;
@end

/// This protocol defines the API for the edit view controller.
@protocol GSGlyphEditViewControllerProtocol <GSGlyphViewControllerProtocol>

/// The actual edit view
@property (readonly, nonatomic) NSView <GSGlyphEditViewProtocol, NSTextInputClient>* graphicView;

/// The writing direction
@property (nonatomic) GSWritingDirection writingDirection;

/// The selected instance in the preview view
@property (nonatomic, assign) NSInteger selectedInstance;

/// The selected features
@property (readonly, nonatomic) NSArray* selectedFeatures;

/// call to update the graphicView
- (void)redraw;

/// updates the graphicView and preview
- (void)forceRedraw;

/// is called when the status bar needs updating
- (void)updateFormatBar;

- (void)updatePreview;
@end
