//
//  GSLayer+MetricsKeysUI.h
//  GlyphsCore
//
//  Created by Georg Seifert on 31.08.15.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>

#if !__has_feature(nullability)
#define NS_ASSUME_NONNULL_BEGIN
#define NS_ASSUME_NONNULL_END
#define nullable
#define nonnull
#define null_unspecified
#define null_resettable
#define __nullable
#define __nonnull
#define __null_unspecified
#endif

typedef NS_ENUM(NSUInteger, GSMetricsKeysUI) {
	GSMetricsKeysOutOfSync = 0,
	GSMetricsKeysInSync = 1,
	GSMetricsKeysInvalid
};

@interface GSLayer (MetricsKeysUI)

@property(nonatomic, unsafe_unretained, nullable) NSString *leftMetricsKeyUI;
- (GSMetricsKeysUI)leftMetricsKeyIsInSync;
- (nonnull NSString *)leftMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSString *__nullable)leftPlainMetricsKey;
- (NSColor *__nonnull)leftMetricsKeyColor;

@property(nonatomic, unsafe_unretained, nullable) NSString *widthMetricsKeyUI;

- (NSString *__nonnull)widthMetricsKeyUIFast;
- (GSMetricsKeysUI)widthMetricsKeyIsInSync;
- (NSString *__nonnull)widthMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSColor *__nonnull)widthMetricsKeyColor;

@property(nonatomic, unsafe_unretained, nullable) NSString *rightMetricsKeyUI;
- (GSMetricsKeysUI)rightMetricsKeyIsInSync;
- (NSString *__nonnull)rightMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSString *__nullable)rightPlainMetricsKey;
- (NSColor *__nonnull)rightMetricsKeyColor;

@property(nonatomic, unsafe_unretained, nullable) NSString *topMetricsKeyUI;
//- (NSString*)topMetricsKeyIsInSync:(BOOL*)IsInSync;

@property(nonatomic, unsafe_unretained, nullable) NSString *bottomMetricsKeyUI;
//- (NSString*)bottomMetricsKeyIsInSync:(BOOL*)IsInSync;

@property(nonatomic, unsafe_unretained, nullable) NSString *vertWidthMetricsKeyUI;
- (GSMetricsKeysUI)vertWidthMetricsKeyIsInSync;
- (NSString *__nonnull)vertWidthMetricsKeyIsInSync:(GSMetricsKeysUI *__nonnull)IsInSync;

@end
