//
//  GSLayerDrawHelper.h
//  Glyphs
//
//  Created by Georg Seifert on 15.05.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSLayer.h>

@class GSPath;

@interface GSLayerDrawHelper : NSObject {
	id __unsafe_unretained delegate;
	NSAffineTransform *_zoomTransformer;
	CGFloat _scale;
	BOOL _showNodes;
	BOOL _fillOutline;
}
@property (strong, nonatomic) NSAffineTransform *zoomTransformer;
@property (nonatomic) CGFloat scale;
@property (unsafe_unretained, nonatomic) id delegate;
@property (nonatomic) BOOL showNodes;
@property (nonatomic) BOOL fillOutline;

- (NSBezierPath *)bezierPathToViewSpace:(NSBezierPath *)bezierPath atPoint:(NSPoint)Point;

- (void)drawLayer:(GSLayer *)Layer atPoint:(NSPoint)Position attributes:(NSDictionary *)Attributes;

- (void)drawHandle:(GSPath *)Path atIndex:(NSUInteger)Index atPoint:(NSPoint)aPoint;

- (NSRect)getHandleRect:(NSPoint)pt atPoint:(NSPoint)aPoint;

#ifndef GLYPHS_VIEWER

- (void)drawShadowAccents:(GSLayer *)Layer atPoint:(NSPoint)aPoint;

#endif

- (void)drawMetricsForLayer:(GSLayer *)Layer atPoint:(NSPoint)Position;

+ (void)drawPlaceholder:(GSLayer*)Layer scale:(CGFloat)scale atPoint:(NSPoint)Position;
+ (void)drawPlaceholder:(GSLayer*)Layer scale:(CGFloat)scale inFrame:(NSRect)Frame metrics:(GSGlyphMetrics)Metrics;
@end
