//
//  GSPointArray.h
//  GlyphsCore
//
//  Created by Georg Seifert on 19/03/16.
//
//

#import <Foundation/Foundation.h>

@interface GSPointArray : NSObject <NSCopying>

- (instancetype)initWithCapacity:(NSUInteger)capacity;
- (NSPoint)pointAtIndex:(NSUInteger)idx;
- (void)setPoint:(NSPoint)point atIndex:(NSUInteger)idx;
- (void)addPoint:(NSPoint)point;
- (NSPointArray)points;
- (NSUInteger)count;

- (instancetype)copySubarrayWithRange:(NSRange)range;

- (NSPoint)lastPoint;
- (NSPoint)firstPoint;
- (void)removePointAtIndex:(NSUInteger)idx;
- (void)insertPoint:(NSPoint)point atIndex:(NSUInteger)idx;
- (void)addPointsFromArray:(GSPointArray *)array;
@end
