//
//  InspectorViewNodesController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSInspectorViewController.h"

@class GSNode;
@class GSTransformGrid;

@interface InspectorViewNodesController : GSInspectorViewController {
	NSTextField *__unsafe_unretained _xField;
	NSTextField *__unsafe_unretained _yField;
	NSTextField *__unsafe_unretained _heightField;
	NSTextField *__unsafe_unretained _widthField;
	GSTransformGrid *__unsafe_unretained _transformGrid;
	NSTextField *__unsafe_unretained _selectedNodeCountField;
	NSTextField *__unsafe_unretained _allNodeCountField;
	NSInteger selectedTransformCorner;
}
@property NSInteger selectedCorner;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *xField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *yField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *heightField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *widthField;
@property (nonatomic, unsafe_unretained) IBOutlet GSTransformGrid *transformGrid;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *selectedNodeCountField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *allNodeCountField;

- (IBAction)setXorigin:(id)sender;
- (IBAction)setYorigin:(id)sender;
- (IBAction)setHeight:(id)sender;
- (IBAction)setWidth:(id)sender;

@end
