//
//  GSAnchor.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.8.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
#if !__has_feature(nullability)
#define NS_ASSUME_NONNULL_BEGIN
#define NS_ASSUME_NONNULL_END
#define nullable
#define nonnull
#define null_unspecified
#define null_resettable
#define __nullable
#define __nonnull
#define __null_unspecified
#endif
NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(uint8_t, GSAnchorType) {
	BaseAnchor = 0,
	MarkAnchor = 1
};

/// The class defining the anchor object

@interface GSAnchor : GSElement <NSCoding, NSCopying> {

	NSString* _name;
	GSAnchorType _type;
	BOOL _selected;
}

/// Name of the anchor.
@property (copy, nonatomic) NSString* name;

@property (nonatomic) GSAnchorType type;

@end
NS_ASSUME_NONNULL_END