//
//  GSComponent.h
//  Glyphs
//
//  Created by Georg Seifert on 30.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"

@class GSGlyph;
@class GSFont;
@class GSLayer;
@class SCEvents;
#ifndef GLYPHS_VIEWER

#import <GlyphsCore/SCEventListenerProtocol.h>

#endif

/** GSBackgroundImage: The class defining the image

 It is a subclass of GSElement
 */
@interface GSBackgroundImage : GSElement
#ifndef GLYPHS_VIEWER
		<SCEventListenerProtocol>
#endif
{
	NSString* _imagePath;
	NSImage* _image;
	NSRect _crop;
	BOOL _didLoad;
	
#ifndef GLYPHS_VIEWER
	SCEvents* _events;
	NSDate* _imageFileDate;
#endif
@public
	NSAffineTransformStruct _transformStruct;
}

//* @name Initialisation*/

/** Inits with a NSURL
 
 @param URL the URL
 */
- (instancetype)initWithURL:(NSURL*)URL;

/** Inits with a path

 @param Path the Path
 */
- (instancetype)initWithPath:(NSString*)Path;

/// the image path
@property (strong, nonatomic) NSString* imagePath;
/// the NSImage
@property (strong, nonatomic) NSImage* image;
/// The Crop
@property (assign, nonatomic) NSRect crop;
/// transparency of rendering in outline mode.
@property (assign, nonatomic) unsigned short alpha;

/** The transformation of the component.

The values of the struct are:
{m11, m12, m21, m22, tX, tY}
this is equivalent to the glif attributes
{xScale, xyScale, yxScale, yScale, xOffset, yOffset}
in the same order.
The initial value is {1,0,0,1,0,0}.
*/
@property (assign, nonatomic) NSAffineTransformStruct transformStruct;

/// Shows the image in the Finder
- (void)showInFinder:(id)sender;

/// toggle locked
- (void)toggleLocked;

- (BOOL)hasValidImageToDraw;

- (BOOL)hasImageToDraw;

- (void)getScaleX:(CGFloat*)sX scaleY:(CGFloat*)sY rotation:(CGFloat*)R;
/**
 Sets the transfomration from scale and angel values
 
 @param sX the horizontal scale value
 @param sY the vertical scale value
 @param R  the angle in degree
 */
- (void)setScaleX:(CGFloat)sX scaleY:(CGFloat)sY rotation:(CGFloat)R;
@end
