//
//  GSCallbackHandler.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08/10/2016.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

#ifndef GSDrawForegroundCallbackName
#define GSDrawForegroundCallbackName @"DrawForeground"
#define GSDrawBackgroundCallbackName @"DrawBackground"
#define GSDrawInactiveCallbackName @"DrawInactive"

#define GSFilterCallbackName @"GSFilterCallbackName"
#define GSPreFilterCallbackName @"GSPreFilterCallbackName"
#define GSPrepareLayerCallbackName @"GSPrepareLayerCallback" 
#endif

@protocol GlyphsReporter;
@class MGOrderedDictionary;

@interface GSCallbackHandler : NSObject {
	NSMutableDictionary *_activeCallbacks;
	NSMutableArray <NSObject <GlyphsReporter>*> *_activeReporters;
	MGOrderedDictionary* _reporterInstances;
}

+ (id)sharedHandler;

@property (strong, nonatomic) MGOrderedDictionary* reporterInstances;

+ (NSArray <NSObject <GlyphsReporter>*>*)activeReporters;

+ (void)resetActiveReporters;

+ (void)activateReporter:(NSObject <GlyphsReporter> *)Reporter;

+ (void)deactivateReporter:(NSObject <GlyphsReporter> *)Reporter;

+ (NSDictionary*)activeCallbacks;

+ (NSArray*)callbacksForType:(NSString*)callbackType;

+ (void)addCallback:(id)target forOperation:(NSString *)operation;

+ (void)removeCallback:(id)target forOperation:(NSString *)operation;

@end
