//
//  GSPartProperty.h
//  GlyphsCore
//
//  Created by Georg Seifert on 29.09.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GSContainerProtocol.h"
/**
 The class implementing the properties in Smart Glyphs. 
 
 See also: [GSGlyph.partsSettings]([GSGlyph partsSettings])
 */
@interface GSPartProperty : NSObject


//* @name Initialisation*/

/** Initialize the object with a dictionary
 
 @param Dict The content of the dict as it is saved to the .glyphs file
 
 The dict may look like this:
 
    {
        bottomValue = 40;
        name = Width;
        topValue = 100;
    }
 
 @return a new instance
 
 @see propertyList
 */
- (instancetype) initWithDict:(NSDictionary*)Dict;

/** The content of the object serialalued as a dictionary.
 
 The dict has a format like this:
 
    {
        bottomValue = 40;
        name = Width;
        topValue = 100;
    }
 
 @return a dict
 
 @see initWithDict:
 */
- (NSDictionary*)propertyList;

//* @name Values

/// The name of the property
@property (strong, nonatomic) NSString* name;

/** A id to use as key in the piecesettings in the components

 this allows to change the name and not loose the settings
 */
@property (strong, nonatomic) NSString* id;


/** The name of the bottom value
 
 This is currently not used, so ignore it.
 */
@property (strong, nonatomic) NSString* bottomName;

/// The lower value for the interpolation range
@property (assign, nonatomic) NSInteger bottomValue;

/** The name of the top value
 
 This is currently not used, so ignore it.
 */
@property (strong, nonatomic) NSString* topName;
/// The upper value for the interpolation range
@property (assign, nonatomic) NSInteger topValue;
@property (assign, nonatomic) CGFloat pieceValue;
@property (weak, nonatomic) id <GSContainerProtocol> pieceComponent;


- (BOOL)saveToFile:(FILE*) File error:(NSError *__autoreleasing*) error;

@end
