//
//  GlyphsFileFormatProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.05.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSFont;

/** GlyphsFileFormat: The protocol defining the file format plugin interface
 
 */
@protocol GlyphsFileFormat
//! The interface version.
@property(readonly) NSUInteger interfaceVersion;
//! The title of the plugin.
@property(readonly) NSString *title;
//! The view to be displayed in the export dialog.
@property(readonly, nonatomic) NSView *exportSettingsView;
/** The GSFont object is assigned the the plugin prior to the export.

 This is used to publish the export dialog.
 */
@property(assign, nonatomic) GSFont *font;
#ifndef GLYPHS_VIEWER

/** Outputs a Font object.

 This function should ask the user for the place to save the store the font.
 @param Font The font to export.
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return YES if the operation was successful; otherwise, NO.
 */
- (BOOL)writeFont:(GSFont *)Font error:(out NSError *__autoreleasing *)error;

/** Outputs a Font object to the specified URL.

 @param Font The font to export.
 @param URL The URL to save the font to.
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return YES if the operation was successful; otherwise, NO.
 */
- (BOOL)writeFont:(GSFont *)Font toURL:(NSURL *)URL error:(out NSError *__autoreleasing *)error;

#endif

/** Reads a Font object from the specified URL.

 @param URL The URL to read the font from.
 @param Type The UTI of the document
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return The font object, or nil if an error occurred.
 */
- (GSFont *)fontFromURL:(NSURL *)URL ofType:(NSString *)Type error:(out NSError *__autoreleasing *)error;

- (NSWindow*)progressWindow;

/// The group ID defines the position of the exporter in the toolbar of the export window.
@property(readonly) NSUInteger groupID;

/// The name in the toolbar of the export window.
@property(readonly) NSString *toolbarTitle;

/// The name of the icon for the tab bar.
@property(readonly) NSImage *toolbarIconName;

@optional

//! do main initialisations
- (void)loadPlugin;

@property(nonatomic, assign) NSDictionary *exportOptions;

/** Import some Data into the existing Font object
 
 @param Font  an existing, already open Font
 @param URL   the file to import from
 @param error on return
 
 @return True if success, False if failure
 */
- (BOOL)importFile:(GSFont *)Font fromURL:(NSURL *)URL error:(out NSError *__autoreleasing *)error;

/// Implement this if you support cancel
- (void)cancelExport;
@end
