//
//  NSString+BadgeDrawing.h
//  GlyphsCore
//
//  Created by Georg Seifert on 01.05.16.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GSGeometrieHelper.h"

@class GSLayer;

@interface NSString (BadgeDrawing)

+ (NSDictionary *_Nonnull)drawTextAttributes:(NSColor *_Nullable)TextColor;

- (void)drawBadgeAtPoint:(NSPoint)position;

- (void)drawBadgeAtPoint:(NSPoint)position alignment:(GSAlignment)Alignment;

- (NSRect)drawBadgeAtPoint:(NSPoint)position alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect;

- (NSRect)drawBadgeAtPoint:(NSPoint)position alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect active:(BOOL)Active;

- (NSRect)drawBadgeAtPoint:(NSPoint)position size:(CGFloat)TextSize color:(NSColor *_Nullable)Color backgroundColor:(NSColor *_Nullable)backgroundColor alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect active:(BOOL)Active;

- (NSRect)drawBadgeAtPoint:(NSPoint)position size:(CGFloat)TextSize color:(NSColor *_Nullable)Color backgroundColor:(NSColor *_Nullable)backgroundColor alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect;

- (NSRect)drawAtPoint:(NSPoint)position color:(NSColor *_Nullable)TextColor;

- (NSRect)drawAtPoint:(NSPoint)position color:(NSColor *_Nullable)TextColor alignment:(GSAlignment)Alignment;

- (NSRect)drawAtPoint:(NSPoint)position color:(NSColor *_Nullable)TextColor alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect;

- (CGFloat)drawAtPoint:(CGPoint)basePoint angle:(CGFloat)angle offset:(CGFloat)offset size:(CGFloat)size color:(NSColor *_Nullable)color alignment:(GSAlignment)alignment;

@end

@interface NSAttributedString (BadgeDrawing)

- (NSRect)drawAtPoint:(NSPoint)position alignment:(GSAlignment)Alignment;

- (NSRect)drawAtPoint:(NSPoint)position alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect;

@end
