//
//  NSStringHelpers.h
//  GlyphsCore
//
//  Created by Georg Seifert on 06.08.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NSString* GSFloatToStringWithPrecision(CGFloat Float, int precision);

void GSFloatToStringWithPrecisionToBuffer(char **buffer, CGFloat Float, int precision);

NSString* GSFloatToStringWithPrecisionMin(CGFloat Float, int precision, int minPrecision);

NSString* GSFloatToStringWithPrecisionLocalized(CGFloat Float, int precision);

NSString* GSFloatToStringLocalized(CGFloat Float);

NSString* GSFloatToString(CGFloat Float);

NSString* GSPointToString(NSPoint P);

@interface NSString (UUID)

- (BOOL)containsString:(NSString *)str;

+ (NSString*)UUID;

+ (NSString*)hexStringFromInt:(NSInteger)Integer;

- (int)hexStringToInt;

+ (NSString *)stringWithChar:(UTF32Char)Char;

- (NSString*)ascciString;

- (NSUInteger)countOfChar:(char)Char;

- (NSString*)absolutePathFromBaseDirPath:(NSString*)baseDirPath;

- (NSString*)relativePathFromBaseDirPath:(NSString*)baseDirPath;

- (NSString*)encodeForPlist;

- (UTF32Char)character32AtIndex:(NSUInteger *)Index;

+ (NSString *)encodeForASCII:(NSString *)String;

+ (NSString *)createStringForKey:(CGKeyCode)keyCode;

- (NSString*)stringByDeletingDotSuffix;
- (NSString*)dotSuffix;
@end

unsigned short writeInt(int n, char* restrict s);

void writeKey(FILE *File, NSString *Key);

BOOL writeKeyValueStringEscape(FILE* File, NSString* Key, NSString* Value, BOOL escape);

BOOL writeKeyValueString(FILE* File, NSString* Key, NSString* Value);
BOOL writeKeyValueStringLine(FILE* File, NSString* Key, NSString* Value);
BOOL writeKeyValueStringSimple(FILE* File, NSString* Key, NSString* Value);
BOOL writeKeyValueInt(FILE* File, NSString* Key, int Value);

BOOL writeKeyValueFloat(FILE* File, NSString* Key, CGFloat Value);
BOOL writeKeyValueFloatPrecition(FILE* File, NSString* Key, CGFloat Value, int precition);
BOOL writeTransform(FILE* File, NSAffineTransformStruct ts, BOOL Compact);
char* writeTransformToBuffer(NSAffineTransformStruct ts, char *buffer);
short actualPrecition(CGFloat Float, int precition);
