/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.gradle.api.Nullable;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceAccessor.class);
    private final HttpClientHelper http;
    private final List<HttpResponseResource> openResources = new ArrayList<HttpResponseResource>();

    public HttpResourceAccessor(HttpClientHelper http) {
        this.http = http;
    }

    @Nullable
    public HttpResponseResource openResource(URI uri) {
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpResponse response = this.http.performGet(location);
        if (response != null) {
            HttpResponseResource resource = this.wrapResponse(uri, response);
            return this.recordOpenGetResource(resource);
        }
        return null;
    }

    public HttpResponseResource getRawResource(URI uri) {
        HttpResponse response;
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpGet request = new HttpGet(uri);
        try {
            response = this.http.performHttpRequest((HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", request.getMethod(), request.getURI()), e);
        }
        HttpResponseResource resource = this.wrapResponse(uri, response);
        return this.recordOpenGetResource(resource);
    }

    public ExternalResourceMetaData getMetaData(URI uri) {
        this.abortOpenResources();
        String location = uri.toString();
        LOGGER.debug("Constructing external resource metadata: {}", (Object)location);
        HttpResponse response = this.http.performHead(location);
        return response == null ? null : new HttpResponseResource("HEAD", uri, response).getMetaData();
    }

    private HttpResponseResource recordOpenGetResource(HttpResponseResource httpResource) {
        this.openResources.add(httpResource);
        return httpResource;
    }

    private void abortOpenResources() {
        for (Closeable closeable : this.openResources) {
            LOGGER.warn("Forcing close on abandoned resource: {}", (Object)closeable);
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close abandoned resource", (Throwable)e);
            }
        }
        this.openResources.clear();
    }

    private HttpResponseResource wrapResponse(URI uri, HttpResponse response) {
        return new HttpResponseResource("GET", uri, response){

            public void close() throws IOException {
                super.close();
                HttpResourceAccessor.this.openResources.remove(this);
            }
        };
    }
}

