/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.routes;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutesCompiler
implements Compiler<RoutesCompileSpec>,
Serializable {
    private final VersionedRoutesCompilerAdapter adapter;

    public RoutesCompiler(VersionedRoutesCompilerAdapter adapter) {
        this.adapter = adapter;
    }

    public WorkResult execute(RoutesCompileSpec spec) {
        Boolean ret;
        boolean didWork = false;
        ArrayList primaryRoutes = Lists.newArrayList();
        ArrayList secondaryRoutes = Lists.newArrayList();
        for (File source : spec.getSources()) {
            if (source.getName().equals("routes")) {
                primaryRoutes.add(source);
                continue;
            }
            secondaryRoutes.add(source);
        }
        for (File sourceFile : secondaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        for (File sourceFile : primaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        return new SimpleWorkResult(didWork);
    }

    private Boolean compile(File sourceFile, RoutesCompileSpec spec) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            ScalaMethod compile = this.adapter.getCompileMethod(cl);
            Object ret = compile.invoke(this.adapter.createCompileParameters(cl, sourceFile, spec.getDestinationDir(), spec.isJavaProject(), spec.isNamespaceReverseRouter(), spec.isGenerateReverseRoutes(), spec.isInjectedRoutesGenerator(), spec.getAdditionalImports()));
            if (ret != null && ret instanceof Boolean) {
                return (Boolean)ret;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking the Play routes compiler.", e);
        }
    }

    public Object getDependencyNotation() {
        return this.adapter.getDependencyNotation();
    }

    public Iterable<String> getClassLoaderPackages() {
        return this.adapter.getClassLoaderPackages();
    }
}

