/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.util.Node;
import groovy.util.NodeList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classpath
extends XmlPersistableConfigurationObject {
    private final FileReferenceFactory fileReferenceFactory;
    private List<ClasspathEntry> entries = Lists.newArrayList();

    public Classpath(XmlTransformer xmlTransformer, FileReferenceFactory fileReferenceFactory) {
        super(xmlTransformer);
        this.fileReferenceFactory = fileReferenceFactory;
    }

    public Classpath() {
        super(new XmlTransformer());
        this.fileReferenceFactory = null;
    }

    public List<ClasspathEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ClasspathEntry> entries) {
        this.entries = entries;
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultClasspath.xml";
    }

    @Override
    protected void load(Node xml) {
        for (Object e : (NodeList)xml.get("classpathentry")) {
            Node entryNode = (Node)e;
            Object kind = entryNode.attribute((Object)"kind");
            if ("src".equals(kind)) {
                String path = (String)entryNode.attribute((Object)"path");
                this.entries.add(path.startsWith("/") ? new ProjectDependency(entryNode) : new SourceFolder(entryNode));
                continue;
            }
            if ("var".equals(kind)) {
                this.entries.add(new Variable(entryNode, this.fileReferenceFactory));
                continue;
            }
            if ("con".equals(kind)) {
                this.entries.add(new Container(entryNode));
                continue;
            }
            if ("lib".equals(kind)) {
                this.entries.add(new Library(entryNode, this.fileReferenceFactory));
                continue;
            }
            if (!"output".equals(kind)) continue;
            this.entries.add(new Output(entryNode));
        }
    }

    public Object configure(List newEntries) {
        LinkedHashSet updatedEntries = Sets.newLinkedHashSet();
        for (ClasspathEntry entry : this.entries) {
            if (this.isDependency(entry) || this.isJreContainer(entry)) continue;
            updatedEntries.add(entry);
        }
        updatedEntries.addAll(newEntries);
        this.entries = Lists.newArrayList((Iterable)updatedEntries);
        return this.entries;
    }

    @Override
    protected void store(Node xml) {
        NodeList classpathEntryNodes = (NodeList)xml.get("classpathentry");
        for (Object classpathEntry : classpathEntryNodes) {
            xml.remove((Node)classpathEntry);
        }
        for (ClasspathEntry entry : this.entries) {
            entry.appendNode(xml);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o;
        return Objects.equal(this.entries, classpath.entries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entries});
    }

    public String toString() {
        return "Classpath{entries=" + this.entries + "}";
    }

    private boolean isDependency(ClasspathEntry entry) {
        return entry instanceof ProjectDependency || entry instanceof AbstractLibrary;
    }

    private boolean isJreContainer(ClasspathEntry entry) {
        return entry instanceof Container && ((Container)entry).getPath().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER");
    }
}

