/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.tooling.internal.gradle.BasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultGradleBuild;
import org.gradle.tooling.internal.gradle.PartialBasicGradleProject;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.GradleBuild");
    }

    public DefaultGradleBuild buildAll(String modelName, Project target) {
        LinkedHashMap<Project, BasicGradleProject> convertedProjects = new LinkedHashMap<Project, BasicGradleProject>();
        BasicGradleProject rootProject = this.convert(target.getRootProject(), convertedProjects);
        DefaultGradleBuild model = new DefaultGradleBuild().setRootProject((PartialBasicGradleProject)rootProject);
        for (Project project : target.getRootProject().getAllprojects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
        return model;
    }

    private BasicGradleProject convert(Project project, Map<Project, BasicGradleProject> convertedProjects) {
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setPath(project.getPath());
        converted.setProjectDirectory(project.getProjectDir());
        if (project.getParent() != null) {
            converted.setParent((PartialBasicGradleProject)convertedProjects.get(project.getParent()));
        }
        convertedProjects.put(project, converted);
        for (Project child : project.getChildProjects().values()) {
            converted.addChild(this.convert(child, convertedProjects));
        }
        return converted;
    }
}

