/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.objectweb.asm.ClassReader;

public class ClassChangeProcessor {
    private final PreviousCompilation previousCompilation;

    public ClassChangeProcessor(PreviousCompilation previousCompilation) {
        this.previousCompilation = previousCompilation;
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        ClassReader classReader;
        try {
            classReader = new ClassReader(Files.toByteArray((File)input.getFile()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to read class file: '%s'", input.getFile()));
        }
        String className = classReader.getClassName().replaceAll("/", ".");
        DependentsSet actualDependents = this.previousCompilation.getDependents(className);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
        } else {
            spec.getClassNames().addAll(actualDependents.getDependentClasses());
        }
    }
}

