/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.MultipleSetterProperty;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Nullable;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.PropertySetTransformer;
import org.gradle.api.internal.coerce.StringToEnumTransformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.SetPropertyResult;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDynamicObject
extends AbstractDynamicObject {
    private static final Method META_PROP_METHOD;
    private static final Field MISSING_PROPERTY_GET_METHOD;
    private final Object bean;
    private final boolean includeProperties;
    private final MetaClassAdapter delegate;
    private final boolean implementsMissing;
    @Nullable
    private final Class<?> publicType;
    private final MethodArgumentsTransformer argsTransformer;
    private final PropertySetTransformer propertySetTransformer;

    public BeanDynamicObject(Object bean) {
        this(bean, null, true, true, StringToEnumTransformer.INSTANCE, StringToEnumTransformer.INSTANCE);
    }

    public BeanDynamicObject(Object bean, @Nullable Class<?> publicType) {
        this(bean, publicType, true, true, StringToEnumTransformer.INSTANCE, StringToEnumTransformer.INSTANCE);
    }

    BeanDynamicObject(Object bean, @Nullable Class<?> publicType, boolean includeProperties, boolean implementsMissing, PropertySetTransformer propertySetTransformer, MethodArgumentsTransformer methodArgumentsTransformer) {
        if (bean == null) {
            throw new IllegalArgumentException("Value is null");
        }
        this.bean = bean;
        this.publicType = publicType;
        this.includeProperties = includeProperties;
        this.implementsMissing = implementsMissing;
        this.propertySetTransformer = propertySetTransformer;
        this.argsTransformer = methodArgumentsTransformer;
        this.delegate = this.determineDelegate(bean);
    }

    public MetaClassAdapter determineDelegate(Object bean) {
        if (bean instanceof Class) {
            return new ClassAdapter((Class)bean);
        }
        if (bean instanceof DynamicObject || bean instanceof DynamicObjectAware || !(bean instanceof GroovyObject)) {
            return new MetaClassAdapter();
        }
        return new GroovyObjectAdapter();
    }

    public BeanDynamicObject withNoProperties() {
        return new BeanDynamicObject(this.bean, this.publicType, false, this.implementsMissing, this.propertySetTransformer, this.argsTransformer);
    }

    public BeanDynamicObject withNotImplementsMissing() {
        return new BeanDynamicObject(this.bean, this.publicType, this.includeProperties, false, this.propertySetTransformer, this.argsTransformer);
    }

    @Override
    public String getDisplayName() {
        return this.bean.toString();
    }

    @Override
    @Nullable
    public Class<?> getPublicType() {
        return this.publicType != null ? this.publicType : this.bean.getClass();
    }

    @Override
    public boolean hasUsefulDisplayName() {
        return !JavaReflectionUtil.hasDefaultToString((Object)this.bean);
    }

    private MetaClass getMetaClass() {
        if (this.bean instanceof GroovyObject) {
            return ((GroovyObject)this.bean).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.bean.getClass());
    }

    @Override
    public boolean hasProperty(String name) {
        return this.delegate.hasProperty(name);
    }

    @Override
    public void getProperty(String name, GetPropertyResult result) {
        this.delegate.getProperty(name, result);
    }

    @Override
    public void setProperty(String name, Object value, SetPropertyResult result) {
        this.delegate.setProperty(name, value, result);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        return this.delegate.hasMethod(name, arguments);
    }

    @Override
    public void invokeMethod(String name, InvokeMethodResult result, Object ... arguments) {
        this.delegate.invokeMethod(name, result, arguments);
    }

    static {
        try {
            META_PROP_METHOD = MetaClassImpl.class.getDeclaredMethod("getMetaProperty", String.class, Boolean.TYPE);
            META_PROP_METHOD.setAccessible(true);
            MISSING_PROPERTY_GET_METHOD = MetaClassImpl.class.getDeclaredField("propertyMissingGet");
            MISSING_PROPERTY_GET_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassAdapter
    extends MetaClassAdapter {
        private final MetaClass classMetaData;

        ClassAdapter(Class<?> cl) {
            this.classMetaData = GroovySystem.getMetaClassRegistry().getMetaClass(cl);
        }

        @Override
        @Nullable
        protected MetaProperty lookupProperty(MetaClass metaClass, String name) {
            MetaProperty metaProperty = super.lookupProperty(metaClass, name);
            if (metaProperty != null) {
                return metaProperty;
            }
            metaProperty = this.classMetaData.getMetaProperty(name);
            if (metaProperty != null && Modifier.isStatic(metaProperty.getModifiers())) {
                return metaProperty;
            }
            return null;
        }

        @Override
        @Nullable
        protected MetaMethod lookupMethod(MetaClass metaClass, String name, Class[] arguments) {
            MetaMethod metaMethod = super.lookupMethod(metaClass, name, arguments);
            if (metaMethod != null) {
                return metaMethod;
            }
            metaMethod = this.classMetaData.getMetaMethod(name, (Object[])arguments);
            if (metaMethod != null && Modifier.isStatic(metaMethod.getModifiers())) {
                return metaMethod;
            }
            return null;
        }
    }

    private class GroovyObjectAdapter
    extends MetaClassAdapter {
        private final GroovyObject groovyObject;

        private GroovyObjectAdapter() {
            this.groovyObject = (GroovyObject)BeanDynamicObject.this.bean;
        }

        protected void setOpaqueProperty(MetaClass metaClass, String name, Object value) {
            this.groovyObject.setProperty(name, value);
        }

        protected Object invokeOpaqueMethod(MetaClass metaClass, String name, Object[] arguments) {
            return this.groovyObject.invokeMethod(name, (Object)arguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetaClassAdapter {
        private MetaClassAdapter() {
        }

        protected String getDisplayName() {
            return BeanDynamicObject.this.getDisplayName();
        }

        public boolean hasProperty(String name) {
            return BeanDynamicObject.this.includeProperties && this.lookupProperty(BeanDynamicObject.this.getMetaClass(), name) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void getProperty(String name, GetPropertyResult result) {
            if (!BeanDynamicObject.this.includeProperties) {
                return;
            }
            MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
            MetaProperty property = this.lookupProperty(metaClass, name);
            if (property != null) {
                if (property instanceof MetaBeanProperty && ((MetaBeanProperty)property).getGetter() == null) {
                    throw BeanDynamicObject.this.getWriteOnlyProperty(name);
                }
                try {
                    result.result(property.getProperty(BeanDynamicObject.this.bean));
                    return;
                }
                catch (InvokerInvocationException e) {
                    if (!(e.getCause() instanceof RuntimeException)) throw e;
                    throw (RuntimeException)e.getCause();
                }
            }
            if (!BeanDynamicObject.this.implementsMissing) {
                return;
            }
            MetaMethod propertyMissing = this.findPropertyMissingMethod(metaClass);
            if (propertyMissing != null) {
                try {
                    result.result(propertyMissing.invoke(BeanDynamicObject.this.bean, new Object[]{name}));
                    return;
                }
                catch (MissingPropertyException e) {
                    if (name.equals(e.getProperty())) return;
                    throw e;
                }
            }
            if (!(BeanDynamicObject.this.bean instanceof GroovyObject) || BeanDynamicObject.this.bean instanceof DynamicObjectAware) return;
            try {
                result.result(((GroovyObject)BeanDynamicObject.this.bean).getProperty(name));
                return;
            }
            catch (MissingPropertyException e) {
                if (name.equals(e.getProperty())) return;
                throw e;
            }
        }

        @Nullable
        private MetaMethod findPropertyMissingMethod(MetaClass metaClass) {
            if (metaClass instanceof MetaClassImpl) {
                try {
                    return (MetaMethod)MISSING_PROPERTY_GET_METHOD.get(metaClass);
                }
                catch (IllegalAccessException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            for (MetaMethod method : metaClass.getMethods()) {
                if (!method.getName().equals("propertyMissing") || method.getParameterTypes().length != 1) continue;
                return method;
            }
            return null;
        }

        @Nullable
        protected MetaProperty lookupProperty(MetaClass metaClass, String name) {
            if (metaClass instanceof MetaClassImpl) {
                try {
                    return (MetaProperty)META_PROP_METHOD.invoke((Object)metaClass, name, false);
                }
                catch (Throwable e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            return metaClass.getMetaProperty(name);
        }

        public void setProperty(String name, Object value, SetPropertyResult result) {
            block13: {
                if (!BeanDynamicObject.this.includeProperties) {
                    return;
                }
                MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
                MetaProperty property = this.lookupProperty(metaClass, name);
                if (property != null) {
                    if (property instanceof MultipleSetterProperty) {
                        String setterName = MetaProperty.getSetterName((String)property.getName());
                        InvokeMethodResult setterResult = new InvokeMethodResult();
                        this.invokeMethod(setterName, setterResult, value);
                        if (setterResult.isFound()) {
                            result.found();
                            return;
                        }
                    } else {
                        if (property instanceof MetaBeanProperty) {
                            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)property;
                            if (metaBeanProperty.getSetter() == null) {
                                if (metaBeanProperty.getField() == null) {
                                    throw BeanDynamicObject.this.setReadOnlyProperty(name);
                                }
                                value = BeanDynamicObject.this.propertySetTransformer.transformValue(metaBeanProperty.getField().getType(), value);
                                metaBeanProperty.getField().setProperty(BeanDynamicObject.this.bean, value);
                            } else {
                                Class setterType = metaBeanProperty.getSetter().getParameterTypes()[0].getTheClass();
                                value = BeanDynamicObject.this.propertySetTransformer.transformValue(setterType, value);
                                value = DefaultTypeTransformation.castToType((Object)value, (Class)setterType);
                                metaBeanProperty.getSetter().invoke(BeanDynamicObject.this.bean, new Object[]{value});
                            }
                        } else {
                            value = BeanDynamicObject.this.propertySetTransformer.transformValue(property.getType(), value);
                            property.setProperty(BeanDynamicObject.this.bean, value);
                        }
                        result.found();
                        return;
                    }
                }
                if (!BeanDynamicObject.this.implementsMissing) {
                    return;
                }
                try {
                    this.setOpaqueProperty(metaClass, name, value);
                    result.found();
                }
                catch (MissingPropertyException e) {
                    if (name.equals(e.getProperty())) break block13;
                    throw e;
                }
            }
        }

        protected void setOpaqueProperty(MetaClass metaClass, String name, Object value) {
            metaClass.invokeMissingProperty(BeanDynamicObject.this.bean, name, value, false);
        }

        public Map<String, ?> getProperties() {
            if (!BeanDynamicObject.this.includeProperties) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            List classProperties = BeanDynamicObject.this.getMetaClass().getProperties();
            for (MetaProperty metaProperty : classProperties) {
                MetaBeanProperty beanProperty;
                if (metaProperty.getName().equals("properties")) {
                    properties.put("properties", properties);
                    continue;
                }
                if (metaProperty instanceof MetaBeanProperty && (beanProperty = (MetaBeanProperty)metaProperty).getGetter() == null) continue;
                properties.put(metaProperty.getName(), metaProperty.getProperty(BeanDynamicObject.this.bean));
            }
            return properties;
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return this.lookupMethod(BeanDynamicObject.this.getMetaClass(), name, this.inferTypes(arguments)) != null;
        }

        private Class[] inferTypes(Object ... arguments) {
            if (arguments == null || arguments.length == 0) {
                return MetaClassHelper.EMPTY_CLASS_ARRAY;
            }
            Class[] classes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                Object argType = arguments[i];
                classes[i] = argType == null ? null : argType.getClass();
            }
            return classes;
        }

        public void invokeMethod(String name, InvokeMethodResult result, Object ... arguments) {
            block8: {
                MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
                MetaMethod metaMethod = this.lookupMethod(metaClass, name, this.inferTypes(arguments));
                if (metaMethod != null) {
                    result.result(metaMethod.doMethodInvoke(BeanDynamicObject.this.bean, arguments));
                    return;
                }
                List metaMethods = metaClass.respondsTo(BeanDynamicObject.this.bean, name);
                for (MetaMethod method : metaMethods) {
                    Object[] transformed;
                    if (method.getParameterTypes().length != arguments.length || (transformed = BeanDynamicObject.this.argsTransformer.transform(method.getParameterTypes(), arguments)) == arguments) continue;
                    result.result(method.doMethodInvoke(BeanDynamicObject.this.bean, transformed));
                    return;
                }
                if (!BeanDynamicObject.this.implementsMissing) {
                    return;
                }
                try {
                    try {
                        result.result(this.invokeOpaqueMethod(metaClass, name, arguments));
                    }
                    catch (InvokerInvocationException e) {
                        if (e.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)e.getCause();
                        }
                        throw e;
                    }
                }
                catch (MissingMethodException e) {
                    if (e.getMethod().equals(name) && Arrays.equals(e.getArguments(), arguments)) break block8;
                    throw e;
                }
            }
        }

        @Nullable
        protected MetaMethod lookupMethod(MetaClass metaClass, String name, Class[] arguments) {
            return metaClass.getMetaMethod(name, (Object[])arguments);
        }

        protected Object invokeOpaqueMethod(MetaClass metaClass, String name, Object[] arguments) {
            return metaClass.invokeMethod(BeanDynamicObject.this.bean, name, arguments);
        }
    }
}

