﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;

public partial class SelectAdPlace : BasePage
{   
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "B1");
        if (!this.IsPostBack) 
        {
            DataBindAd();
        }
    }
    #region 绑定数据方法
    private void DataBindAd()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "T_ID";
        PageNo1.Table = "W_Ad_Table";
        PageNo1.StrGetFields = "*";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            GridView1.DataSource = dt.DefaultView;
            GridView1.DataBind();
        }
        else {
            if (this.TxB_Name.Text != "" || this.TxB_Name.Text != null)   //广告位名称
            {
                strWhere += " and Ad_Name like '%" +Base.GetRequest.Filter(this.TxB_Name.Text.ToString().Trim())+ "%'";
            }
            if (this.TxB_Type.Text != " " || this.TxB_Type.Text != null)    //广告类型
            {
                strWhere += " and Ad_Type like '%" + this.TxB_Type.SelectedValue.ToString().Trim() + "%'";
            }
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            GridView1.DataSource = dt.DefaultView;
            GridView1.DataBind();
        }
    }
    #endregion
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e) 
    {
        if (e.CommandName == "delet") 
        {
           string id=e.CommandArgument as string;
           int tid = Convert.ToInt32(id);
           DAL.Ad.AdPlaceManage adi = new DAL.Ad.AdPlaceManage();
           adi.DeleteAdInfo(tid);
           DeleteJs(Server.MapPath("~/js/Advertisement/" + id + ".js"));
           DataBindAd();

        }
        if (e.CommandName == "Issue")
        {
            string tid = e.CommandArgument as string;
            Response.Redirect("IssueAd.aspx?tid=" + tid);
        }
        if (e.CommandName =="JsUrl") 
        {
            string tid = e.CommandArgument as string;
            string url ="JsUrl.aspx?id="+tid;
            Response.Redirect(url);
        }
    }
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {   
        GridViewRow row = this.GridView1.SelectedRow;
        System.Web.UI.WebControls.Label tid = row.FindControl("Lb_ID") as System.Web.UI.WebControls.Label;
        Session["id"] = tid.Text.ToString();
       Response.Redirect("AdPlaceEdit.aspx");
    }
    protected void Button5_Click(object sender, EventArgs e)
    {
        //搜索数据
        DataBindAd();

    }
    protected void DeleteJs(string path) 
    {
        //删除js文件
        try
        {
            if (System.IO.File.Exists(Server.MapPath(path))) 
             {
                System.IO.File.Delete(path);
              }
        }
        catch
        {
           Response.Write("");
        }
       
    }
    protected void Btn_deletAll_Click(object sender, EventArgs e)
    {
        foreach (GridViewRow row in this.GridView1.Rows)
        {
            CheckBox ck = row.FindControl("ckb_Ad") as CheckBox;
            System.Web.UI.WebControls.Label lb = row.FindControl("Lb_ID") as System.Web.UI.WebControls.Label;
            if (ck.Checked==true)
            {
                DAL.Ad.AdPlaceManage adi = new DAL.Ad.AdPlaceManage();
                adi.DeleteAdInfo(Convert.ToInt32(lb.Text.ToString()));
                DeleteJs(Server.MapPath("~/js/Advertisement/" + Convert.ToInt32(lb.Text.ToString()) + ".js"));
                DataBindAd();
            }
        }
    }    
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
