﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using DAL.Ad;
using Base;
public partial class Admin : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "B1");
        if (!this.IsPostBack)
        {
            DataBindPage();
        }
    }

    private void DataBindPage()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = " 1=1 ";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = " W_Ad_MemberInfo.Ad_AddDate desc, W_Ad_MemberInfo.M_ID";
        PageNo1.Table = "(W_Ad_Table INNER JOIN W_Ad_MemberInfo ON W_Ad_Table.T_ID = W_Ad_MemberInfo.T_ID) LEFT JOIN U_UserInfo ON W_Ad_MemberInfo.[User_ID]=U_UserInfo.[UserID]";
        PageNo1.StrGetFields = "W_Ad_Table.T_ID, W_Ad_Table.Ad_Type, W_Ad_Table.Ad_Name, W_Ad_Table.Ad_Page, W_Ad_Table.Ad_Height, W_Ad_Table.Ad_Width, W_Ad_Table.DayMoney, W_Ad_Table.Ad_StartDate,W_Ad_MemberInfo.Ad_MemberInfoName, W_Ad_MemberInfo.Ad_Adrees,W_Ad_MemberInfo.Ad_Leter,W_Ad_MemberInfo.Ad_ImageAdrees ,W_Ad_MemberInfo.Ad_Day,W_Ad_MemberInfo.M_ID,W_Ad_MemberInfo.[User_ID],W_Ad_MemberInfo.[Ad_RestrictTime],U_UserInfo.[LoginName],W_Ad_MemberInfo.[Ad_Auditing]";
        PageNo1.PageSize = 12;
        DataTable table = new DataTable();
        if (Request.QueryString["page"] != null)
        {
            if (Session["strWhere"] != null)
            {
                strWhere = Session["strWhere"].ToString();
            }
            else
            {
                strWhere = " 1=1 ";
            }
            PageNo1.Tb_Id = "W_Ad_MemberInfo.M_ID";
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            table = PageNo1.BindViewDesc();
            if (table.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "<font color='red'>暂无数据！</font>";
            }
            else
            {
                lblMessage.Visible = false;
            }
        }
        else
        {   
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            PageNo1.Tb_Id = "W_Ad_MemberInfo.M_ID";
            table = PageNo1.BindViewDesc();
            if (table.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "<font color='red'>暂无数据！</font>";
            }
            else
            {
                lblMessage.Visible = false;
            }            
        }
        GridView1.DataSource = table.DefaultView;
        GridView1.DataBind();
        table.Dispose();
        table.Clear();
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            System.Web.UI.WebControls.Label l1 = e.Row.FindControl("Lb_User") as System.Web.UI.WebControls.Label;
            if (l1.Text == "" || l1.Text == null)
            {
                l1.Text = "管理员";
            }
        }
    }
    #region 处理RowCommand事件
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {

        if (e.CommandName == "select")
        {
            string id = e.CommandArgument as string;
            int mid = Convert.ToInt32(id);
            string strDate = DateTime.Now.ToString("yyyyMM");
            string imgpath = ((Label)GridView1.Rows[0].Cells[0].FindControl("Lb_ImagAdres")).Text;
            imgpath = "img/" + strDate + imgpath.Substring(imgpath.LastIndexOf("//") + 1);
            AdPlaceManage adi = new AdPlaceManage();
            adi.DeletMemberAdInfo(mid);
            DeleteFile(Server.MapPath(imgpath));
        }
        else
        {
            string id = e.CommandArgument as string;
            string str = e.CommandName;
            if (str == "通过")
            {
                str = "未通过";
            }
            else
            {
                str = "通过";
            }
            int mid = Convert.ToInt32(id);
            DAL.Ad.MemberInfo mo = new MemberInfo();
            mo.ShenHe(mid, str);
            string strURl = Request.RawUrl;
            strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
            Response.Redirect(strURl + "?page=1");
            Response.End();
        }
        string strURl1 = Request.RawUrl;
        strURl1 = strURl1.Substring(0, strURl1.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl1 + "?page=1");
        Response.End();
    }

    #endregion
    #region //删除图片文件
    protected void DeleteFile(string path)
    {
        try
        {
            if (System.IO.File.Exists(path))
            {
                System.IO.File.Delete(path);
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }
    #endregion

    /// <summary>
    /// 搜索用户申请的广告信息
    /// </summary>
    protected void Button5_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        if (this.TxB_Name.Text != "")   //广告位名称
        {
            strWhere += " and Ad_MemberInfoName like '%" + Base.GetRequest.Filter(this.TxB_Name.Text.ToString().Trim()) + "%'";
        }
        if (this.TxB_Type.Text.Trim() != "")    //广告类型
        {
            strWhere += " and Ad_Type like '%" + Base.GetRequest.Filter(this.TxB_Type.Text.ToString().Trim()) + "%'";
        }
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    /// <summary>
    /// 全部删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AllDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < this.GridView1.Rows.Count; i++)
        {
            GridViewRow row = this.GridView1.Rows[i];
            System.Web.UI.WebControls.Label l1 = row.FindControl("Lb_mid") as System.Web.UI.WebControls.Label;
            int mid = Convert.ToInt32(l1.Text.ToString());
            System.Web.UI.WebControls.Label imgadrees = row.FindControl("Lb_ImagAdres") as System.Web.UI.WebControls.Label;
            CheckBox cek = row.FindControl("ckb_Ad") as CheckBox;
            if (cek.Checked)
            {
                AdPlaceManage adi = new AdPlaceManage();
                adi.DeletMemberAdInfo(mid);
               // DeleteFile(Server.MapPath(imgadrees.Text.ToString()));
            }
        }
        Response.Write("<script>alert('你还未选择你要删除的')</script>");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        GridViewRow row = this.GridView1.SelectedRow;
        System.Web.UI.WebControls.Label l1 = row.FindControl("Lb_mid") as System.Web.UI.WebControls.Label;
        int mid = Convert.ToInt32(l1.Text.ToString());
        System.Web.UI.WebControls.Label imgadrees = row.FindControl("Lb_ImagAdres") as System.Web.UI.WebControls.Label;
        AdPlaceManage adi = new AdPlaceManage();
        adi.DeletMemberAdInfo(mid);
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
}
