﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Model.Ad;
using BLL.Ad;
public partial class IssueAd : System.Web.UI.Page
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            DataBindAd();
        }
    }

    private void DataBindAd()
    {
        string id=Request.QueryString["tid"] as string;
        int tid = Convert.ToInt32(id);
        string strWhere = "W_Ad_MemberInfo.[Ad_Auditing]='通过'";
        if (id != "" || id != null) 
        {
            strWhere += " and W_Ad_MemberInfo.[T_ID]=" + id;
        }
        string tableName = "(W_Ad_Table INNER JOIN W_Ad_MemberInfo ON W_Ad_Table.T_ID = W_Ad_MemberInfo.T_ID) LEFT JOIN U_UserInfo ON W_Ad_MemberInfo.[User_ID]=U_UserInfo.[UserID]";
        string clumName = "W_Ad_Table.T_ID, W_Ad_Table.Ad_Type, W_Ad_Table.Ad_Name, W_Ad_Table.Ad_Page, W_Ad_Table.Ad_Height, W_Ad_Table.Ad_Width, W_Ad_Table.DayMoney, W_Ad_Table.Ad_StartDate,W_Ad_MemberInfo.Ad_MemberInfoName, W_Ad_MemberInfo.Ad_Adrees,W_Ad_MemberInfo.Ad_Leter,W_Ad_MemberInfo.Ad_ImageAdrees ,W_Ad_MemberInfo.Ad_Day,W_Ad_MemberInfo.M_ID,W_Ad_MemberInfo.[User_ID],W_Ad_MemberInfo.[Ad_RestrictTime],U_UserInfo.[LoginName]";
        DataTable dt = Base.PageList.GetDataTable(strWhere, tableName, 0, "W_Ad_Table.T_ID", clumName, pageSize, Pageindex, 0);
        DataTable table = Base.PageList.GetDataTable(strWhere, tableName);
        PageCount = Convert.ToInt32(table.Rows[0]["Total"]);
        this.txt_pageCount.Text = PageCount.ToString();
        if (Pageindex == 1)
        {
            this.btn_pageFirst.Enabled = false;
            this.btn_pageLast.Enabled = false;
        }
        else
        {
            this.btn_pageFirst.Enabled = true;
            this.btn_pageLast.Enabled = true;
        }
        if (Pageindex == (PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1))
        {
            this.btn_pageNext.Enabled = false;
            this.btn_pageFoot.Enabled = false;
        }
        else
        {
            this.btn_pageNext.Enabled = true;
            this.btn_pageFoot.Enabled = true;
        }
        this.txt_begin.Text = Pageindex.ToString();
        this.txt_pageAll.Text = Convert.ToString((PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1));
        this.txt_PageNum.Text = Pageindex.ToString();

        GridView1.DataSource = dt.DefaultView;
        GridView1.DataBind();
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            System.Web.UI.WebControls.Label l1 = e.Row.FindControl("Lb_userid") as System.Web.UI.WebControls.Label;
            if (l1.Text == "" || l1.Text == null)
            {
                l1.Text = "管理员";
            }
        }
    }
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        GridViewRow row = this.GridView1.SelectedRow;
        System.Web.UI.WebControls.Label l1 = row.FindControl("Lb_ID") as System.Web.UI.WebControls.Label;
        System.Web.UI.WebControls.Label l2 = row.FindControl("Lb_Adrees") as System.Web.UI.WebControls.Label;
        System.Web.UI.WebControls.Label l3 = row.FindControl("Lb_ImageAdrees") as System.Web.UI.WebControls.Label;
        System.Web.UI.WebControls.Label l4 = row.FindControl("Lb_Width") as System.Web.UI.WebControls.Label;
        System.Web.UI.WebControls.Label l5 = row.FindControl("Lb_Height") as System.Web.UI.WebControls.Label;
        System.Web.UI.WebControls.Label l6 = row.FindControl("Lb_Type") as System.Web.UI.WebControls.Label;
        
        AdItiem adi = new AdItiem();
        AdMemberInfo adm = new AdMemberInfo();
        adi.Id = Convert.ToInt32(l1.Text);
        adi.AdWidth = Convert.ToInt32(l4.Text);
        adi.AdHeight = Convert.ToInt32(l5.Text);
        adi.Type = l6.Text;
        adm.MImageAdrees = l3.Text;
        adm.M_Adrees = l2.Text;

        CreatJs cjs = new CreatJs();
        cjs.CreatJsFile(adi, adm);

        System.Web.UI.WebControls.Label lmid = row.FindControl("Lb_mid") as System.Web.UI.WebControls.Label;
        int mid = Convert.ToInt32(lmid.Text.ToString ());
        int tid = Convert.ToInt32(l1.Text.ToString());
        DAL.Ad.AdPlaceManage addt = new DAL.Ad.AdPlaceManage();
        addt.IssueAd(mid, tid);
       // Response.Write("<script>alert('发布成功');</script>");
        DataBindAd();
    }

    #region 分页事件
    protected void btn_pageFirst_Click(object sender, EventArgs e)
    {
        //首页事件
        this.Pageindex = 1;
        DataBindAd();
    }
    protected void btn_pageLast_Click(object sender, EventArgs e)
    {
        //上一页
        this.Pageindex--;
        DataBindAd();
    }
    protected void btn_pageNext_Click(object sender, EventArgs e)
    {
        //下一页
        this.Pageindex++;
        DataBindAd();
    }
    protected void btn_pageFoot_Click(object sender, EventArgs e)
    {
        //末页
        this.Pageindex = PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1;
        DataBindAd();
    }
    protected void btn_go_Click(object sender, EventArgs e)
    {
        //跳到指定的页
        string txtNumber = this.txt_PageNum.Text.ToString().Trim();
        int index = 1;
        if (Base.Common.CheckNum(txtNumber))
        {
            index = Convert.ToInt32(txtNumber);
            if (index >= 1 && index <= (PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1))
            {
                Pageindex = index;
                DataBindAd();
            }
            else
            {
                Pageindex = 1;
                this.txt_PageNum.Text = "1";
            }
        }
        else
        {
            Pageindex = 1;
            this.txt_PageNum.Text = "1";
        }
    }
    #endregion
}
