﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;


/// <summary>
/// 加盟类别列表管理页面
/// </summary>
public partial class admin_Agent_AgentTypeList : BasePage
{

    private int pageSize = 12;//这里设置分页尺寸  

    /// <summary>
    /// 页面加载事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();  
        }
    }

    /// <summary>
    /// 绑定类别数据事件
    /// </summary>
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.Table = " W_AgentType ";
        PageNo1.FldName = " W_AgentType.Compositor ";
        PageNo1.StrGetFields = " W_AgentType.* ";
        PageNo1.PageSize = pageSize;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindView();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdAgentType.DataSource = dt.DefaultView;
            grdAgentType.DataBind();
        }
        else {
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindView();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdAgentType.DataSource = dt.DefaultView;
            grdAgentType.DataBind();

        }      
      
    }

    /// <summary>
    ///  删除商业信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdAgentType.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdAgentType.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int ID = Convert.ToInt32(grdAgentType.DataKeys[i].Value);
                IAgentType RAgen = new RAgentType();
                int m = RAgen.Delete(ID);
            }
        }
        Bind();
    }

    protected void grdAgentType_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdAgentType.DataKeys[e.RowIndex].Value.ToString());
        IAgentType RAgen = new RAgentType();
        RAgen.Delete(id);
        Bind();
    }

    protected void grdAgentType_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        grdAgentType.EditIndex = -1;
        Bind();
    }

    /// <summary>
    /// 更新类别信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdAgentType_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int id = int.Parse(grdAgentType.DataKeys[e.RowIndex].Value.ToString());
        string name = ((TextBox)grdAgentType.Rows[e.RowIndex].FindControl("txtTName")).Text;
        int compositor = int.Parse(((TextBox)grdAgentType.Rows[e.RowIndex].FindControl("txt_Compositor")).Text);
        TAgentType TArea = new TAgentType();
        TArea.ID = id;
        TArea.Name = name;
        TArea.Compositor = compositor;
        IAgentType RAgen = new RAgentType();
        RAgen.Update(TArea);
        grdAgentType.EditIndex = -1;
        Bind();
    }

    protected void grdAgentType_RowEditing(object sender, GridViewEditEventArgs e)
    {
        grdAgentType.EditIndex = e.NewEditIndex;
        Bind();
    }

    protected void grdAgentType_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdAgentType.SelectedIndex = e.NewPageIndex;
        Bind();
    }

    protected void ButJS_Click(object sender, EventArgs e)
    {
        /*bool b = WriteFile();
        if (b == true)
        {
            Response.Write("<script>alert('生成成功！');</script>");
        }
        else
        {
            Response.Write("<script>alert('生成失败！');</script>");
        }*/
    }

    /* public static bool WriteFile()
     {
         string sPath = AppDomain.CurrentDomain.BaseDirectory.ToString() + "js\\Agent.js";
         Encoding code = Encoding.GetEncoding("gb2312");
         // 读取模板文件 
         StreamWriter sw = null;
         // 替换内容 
         // 这时,模板文件已经读入到名称为str的变量中了 
         string str = Base.CreateJS.Create(); //模板页中的ShowArticle 
         // 写文件 
         try
         {
             sw = new StreamWriter(sPath, false, code);
             sw.Write(str);

             sw.Flush();
         }
         catch (Exception ex)
         {
             HttpContext.Current.Response.Write(ex.Message);
             HttpContext.Current.Response.End();
         }
         finally
         {
             sw.Close();
         }
         return true;

     }*/

    /// <summary>
    /// 添加类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int ParentID = 0;
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                ParentID = int.Parse(Request.QueryString["ParentID"]);
            }
            TAgentType TAgent = new TAgentType();
            TAgent.Name = txtName.Text;
            TAgent.ParentID = ParentID;
            IAgentType RAgent = new RAgentType();
            RAgent.Insert(TAgent);
            ShowMessage("类名添加成功！", "Agent/AgentTypeList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("添加失败!", "Agent/AgentTypeList.aspx");
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Lkbtn_AllDelete_Click(object sender, EventArgs e)
    {
        if (pnlIndustryType.Visible)
            pnlIndustryType.Visible = false;
        else
            pnlIndustryType.Visible = true;
    }

    /// <summary>
    /// 排序
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        foreach (GridViewRow rows in this.grdAgentType.Rows)
        {
            TextBox txt = rows.FindControl("txt_Compositor") as TextBox;
            Label lbid = rows.FindControl("Lb_id") as Label;
            int txtd = 0;
            if (GetRequest.isNum(txt.Text.ToString()))
                txtd = Convert.ToInt32(txt.Text.ToString());
            int lbxid = Convert.ToInt32(lbid.Text.ToString());
            RAgentType rat = new RAgentType();
            rat.UpdateCompositor(txtd, lbxid);
        }
        Bind();
    }

    /// <summary>
    /// 获取第二级子菜单并让控件不可用
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdAgentType_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            if (Request.QueryString["ParentID"] != null)
            {
                HyperLink hp = e.Row.Cells[3].FindControl("TypeName") as HyperLink;
                HyperLink hl = e.Row.Cells[4].FindControl("AddType") as HyperLink;
                if (hp != null)
                {
                    hp.Enabled = false;
                }
                if (hl != null)
                {
                    hl.Enabled = false;
                }
            }
        }
    }   
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        pnlIndustryType.Visible = false;
    }
    //protected void lbtnBank_Click(object sender, EventArgs e)
    //{
    //    Response.Redirect("AgentTypeList.aspx");
    //}
    protected void grdAgentType_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
