﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using Base;
using Agent;
using System.Data.SqlClient;

public partial class admin_Agent_SincereAgentEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            ProvinceBind();
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null)
        {
            if (Request.QueryString["UserID"] != null)
                this.HiddUserID.Value = Request.QueryString["UserID"].ToString();
            int id = int.Parse(Request.QueryString["ID"].ToString());
            ISincereAgent RSin = new RSincereAgent();
            TSincereAgent TSin = RSin.GateItem(id);
            if (TSin.AgentType != null)
            {
                string Sql = "SELECT [ParentID] FROM [W_AgentType] WHERE [ID]=" + TSin.AgentType;
                SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString);
                SqlCommand cmd = new SqlCommand(Sql, con);
                using (con)
                {
                    con.Open();
                    SqlDataReader sr = cmd.ExecuteReader();
                    if (sr.Read())
                    {
                        string ParentID = sr["ParentID"].ToString();
                        sr.Close();
                        con.Close(); if (ParentID.Equals("0"))
                        {
                            lstParentType.SelectedValue = TSin.AgentType.ToString();
                        }
                        else
                        {
                            lstParentType.SelectedValue = ParentID;
                            RSincereAgent SonInfo = new RSincereAgent();
                            DataTable dt = SonInfo.GetSonType(int.Parse(ParentID));
                            if (dt != null)
                            {
                                lstSonType.DataSource = dt;
                                lstSonType.DataTextField = "Name";
                                lstSonType.DataValueField = "ID";
                                lstSonType.DataBind();
                                lstSonType.SelectedValue = TSin.AgentType.ToString();
                            }
                        }

                    }
                    else
                        lstParentType.SelectedValue = TSin.AgentType.ToString();
                }
            }
            txtName.Text = TSin.Name;
            txtTitle.Text = TSin.Title;

            radlValidity.SelectedValue = TSin.Validity;
            txtBrand.Text = TSin.Brand;
            dropInvestment.SelectedValue = TSin.Investment;
            txtAmount.Text = TSin.Amount.ToString();
            txtInitialFee.Text = TSin.InitialFee.ToString();
            dropRequire.SelectedValue = TSin.Require;

            if (TSin.Cradle != "" && TSin.Cradle != null)
            {
                txtCradle.Text = TSin.Cradle;
            }
            if (TSin.Payback.ToString() != "" && TSin.Payback.ToString() != "0")
            {
                txtPayback.Text = TSin.Payback.ToString();
            }
            if (TSin.Period.ToString() != "" && TSin.Period.ToString() != "0")
            {
                txtPeriod.Text = TSin.Period.ToString();
            }
            if (TSin.Concession.ToString() != "" && TSin.Concession.ToString() != "0")
            {
                txtConcession.Text = TSin.Concession.ToString();
            }
            if (TSin.Contract.ToString() != "" && TSin.Contract.ToString() != "0")
            {
                txtContract.Text = TSin.Contract.ToString();
            }
            if (TSin.Count.ToString() != "" && TSin.Count.ToString() != "0")
            {
                txtCount.Text = TSin.Count.ToString();
            }
            if (TSin.isMoreBrand.ToString() != "")
            {
                radlisMoreBrand.SelectedValue = TSin.isMoreBrand.ToString();
            }
            if (TSin.BusinessDate.ToString() != "" && TSin.BusinessDate.ToString() != "0")
            {
                txtBusinessDate.Text = TSin.BusinessDate.ToString();
            }
            if (TSin.BusinessMode != "" && TSin.BusinessMode != null)
            {
                string[] str = TSin.BusinessMode.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    chklBusinessMode.Items[Convert.ToInt32(str[i])].Selected = true;
                }
            }
            if (TSin.Developmental != "" && TSin.Developmental != null)
            {
                string[] str = TSin.Developmental.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    chklDevelopmental.Items[Convert.ToInt32(str[i])].Selected = true;
                }
            }
            Detail.Value = TSin.Detail;
            string names = Path.GetFileName(ImgUrl1.Value);
            if (TSin.Picture == "")
            {
                this.ImgUrl1.Value = "../../Images/System/wutu.gif";
                this.ImgUrl.Src = "../../Images/System/wutu.gif";
            }
            else
            {
                ImgUrl1.Value = TSin.Picture;
                ImgUrl.Src = TSin.Picture;

            }
        }
    }
    private void ProvinceBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/Province.xml"));
        dropRequire.DataSource = ds.Tables[0];
        dropRequire.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropRequire.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropRequire.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            if (lstSonType.SelectedValue != "")
            {
                myValue = lstSonType.SelectedValue;
            }
            else
            {
                myValue = lstParentType.SelectedValue;
            }
            TSincereAgent TSin = new TSincereAgent();
            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSin.ID = id;
            }
            TSin.Name = txtName.Text.Trim();
            TSin.Title = txtTitle.Text;
            TSin.AgentType = int.Parse(myValue);
            TSin.Validity = radlValidity.SelectedValue;
            TSin.Brand = txtBrand.Text.Trim();
            TSin.Investment = dropInvestment.SelectedValue;
            if (GetRequest.isProce(txtAmount.Text.Trim()))
                TSin.Amount = Convert.ToDecimal(txtAmount.Text.Trim());
            else
                TSin.Amount = 0;
            if (GetRequest.isProce(txtInitialFee.Text.Trim()))
                TSin.InitialFee = Convert.ToDecimal(txtInitialFee.Text.Trim());
            else
                TSin.InitialFee = 0;
            TSin.Require = dropRequire.SelectedValue;
            if (txtCradle.Text != "")
                TSin.Cradle = txtCradle.Text.Trim();
            if (txtPayback.Text != "")
            {
                if (GetRequest.isProce(txtPayback.Text.Trim()))
                    TSin.Payback = Convert.ToDecimal(txtPayback.Text.Trim());
                else
                    TSin.Payback = 0;
            }
            if (txtPeriod.Text != "")
            {
                if (GetRequest.isProce(txtPeriod.Text.Trim()))
                    TSin.Period = Convert.ToDecimal(txtPeriod.Text.Trim());
                else
                    TSin.Period = 0;
            }
            if (txtConcession.Text != "")
            {
                if (GetRequest.isProce(txtConcession.Text.Trim()))
                    TSin.Concession = Convert.ToDecimal(txtConcession.Text.Trim());
                else
                    TSin.Concession = 0;
            }
            if (txtContract.Text != "")
            {
                if (GetRequest.isProce(txtContract.Text.Trim()))
                    TSin.Contract = Convert.ToDecimal(txtContract.Text.Trim());
                else
                    TSin.Contract = 0;
            }
            if (radlisMoreBrand.SelectedValue != "")
                TSin.isMoreBrand = Convert.ToBoolean(radlisMoreBrand.SelectedValue);

            if (GetRequest.isNum(txtCount.Text.Trim()))
                TSin.Count = Convert.ToInt32(txtCount.Text.Trim());
            else
                TSin.Count = 0;
            if (GetRequest.isNum(txtBusinessDate.Text.Trim()))
                TSin.BusinessDate = Convert.ToInt32(txtBusinessDate.Text.Trim());
            else
                TSin.BusinessDate = 0;
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklBusinessMode.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.BusinessMode = myValue;
            }
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklDevelopmental.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.Developmental = myValue;
            }
            string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
            Temp = GetRequest.WipeScript(Temp);
            TSin.Detail = Temp;
            TSin.Picture = ImgUrl1.Value;
            ISincereAgent RSin = new RSincereAgent();
            RSin.Update(TSin);
            ShowMessage("商机发布成功！", "Agent/SincereAgentList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("商机发布失败!", "Agent/SincereAgentList.aspx");
        }
    }

    protected void bntBack_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='SincereAgentList.aspx'</script>");
    }
    protected void lstParentType_SelectedIndexChanged(object sender, EventArgs e)
    {
        int ParentID = int.Parse(lstParentType.SelectedValue);
        RSincereAgent SonInfo = new RSincereAgent();
        DataTable dt = SonInfo.GetSonType(ParentID);
        if (dt != null)
        {
            lstSonType.DataSource = dt;
            lstSonType.DataTextField = "Name";
            lstSonType.DataValueField = "ID";
            lstSonType.DataBind();
        }
    }
}
