﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;

public partial class admin_Agent_SincereAgentList : Base.BasePage
{    
    #region 绑定数据方法
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_SincereAgent,W_AgentType";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "W_SincereAgent.*,W_AgentType.Name as TypeName";
        PageNo1.PageSize = 12;
        string strWhere = "W_AgentType.ID=W_SincereAgent.AgentType";
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
            {
                strWhere = Session["strWhere"].ToString();
            }
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂时无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdSincereAgent.DataSource = dt.DefaultView;
            grdSincereAgent.DataBind();
        }
        else
        {
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " and W_SincereAgent.Verify=1";
                        break;
                    case "2":
                        strWhere += " and W_SincereAgent.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    case "3":
                        strWhere += " and W_SincereAgent.Recommend=1";
                        this.Label4.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            else
            {
                this.Label1.CssClass = "pl";
            }
            string TitleName = Base.GetRequest.Filter(txtTitleName.Text.Trim());
            if (TitleName != "")
                strWhere += " and W_SincereAgent.Title like '%" + TitleName + "%'";
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂时无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdSincereAgent.DataSource = dt.DefaultView;
            grdSincereAgent.DataBind();
        }
    }
    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            AgentTypeBind();
            Bind();
        }

    }
    private void AgentTypeBind()
    {
        dropAgentType.Items.Add(new ListItem("--请选择类目--", "0"));
        RAgentType RAgent = new RAgentType();
        DataTable dt = RAgent.GetAllParentItem();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropAgentType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdSincereAgent.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSincereAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdSincereAgent.DataKeys[i].Value);
                ISincereAgent RUser = new RSincereAgent();
                int m = RUser.Delete(id);
            }
        }
        Bind();
    }

    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        TSincereAgent TSin = new TSincereAgent();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TSin.ID = int.Parse(Content.Substring(0, index));
        TSin.Verify = int.Parse(Content.Substring(index + 1));
        ISincereAgent RPur = new RSincereAgent();
        RPur.UpdateVerify(TSin);
        Bind();
    }

    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        ISincereAgent rs = new RSincereAgent();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = rs.Delete(id);
        Bind();
    }

    protected void lbtnUpdateRecommend_Command(object sender, CommandEventArgs e)
    {
        TSincereAgent TSin = new TSincereAgent();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TSin.ID = int.Parse(Content.Substring(0, index));
        TSin.Recommend = Convert.ToBoolean(Content.Substring(index + 1));
        ISincereAgent RPur = new RSincereAgent();
        RPur.UpdateRecommend(TSin);
        Bind();
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "W_AgentType.ID=W_SincereAgent.AgentType";
        if (dropAgentType.SelectedValue.Equals("0"))
        {

        }
        else if ((!dropAgentType.SelectedValue.Equals("0")))
        {
            strWhere += " AND W_SincereAgent.AgentType=" + dropAgentType.SelectedValue;
        }
        //" W_AgentType.ID=W_SincereAgent.AgentType";
        string TitleName = Base.GetRequest.Filter(txtTitleName.Text.Trim());
        if (TitleName != "")
            strWhere += " and W_SincereAgent.Title like '%" + TitleName + "%'";
        Session["strWhere"] = strWhere;
        string strURl1 = Request.RawUrl;
        strURl1 = strURl1.Substring(0, strURl1.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl1);
        Response.End();
    }



    /// <summary>
    /// 审核通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdSincereAgent.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSincereAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdSincereAgent.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Agent/SincereAgentList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_SincereAgent", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Agent/SincereAgentList.aspx");
        }

    }


    /// <summary>
    /// 审核未通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdSincereAgent.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSincereAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdSincereAgent.DataKeys[i].Value);
            }
        }

        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Agent/SincereAgentList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_SincereAgent", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Agent/SincereAgentList.aspx");
        }
    }


    /// <summary>
    /// 绑定审核状态
    /// </summary>
    /// <param name="strVerify"></param>
    /// <returns></returns>
    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "2")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }


    protected void grdSincereAgent_RowDataBound1(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            //LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            LinkButton btn1 = (LinkButton)e.Row.FindControl("lbtnUpdateRecommend");
            //if (btn.Text == "已审")
            //    btn.Attributes.Add("onclick", "javascript:return confirm('你要取消审核吗？')");
            //else
            //    btn.Attributes.Add("onclick", "javascript:return confirm('你要让该会员通过审核吗？请注意该会员是否满足该等级的条件要求！通过审核后,将开通该会员服务功能？')");
            if (btn1.Text == "推荐")
                btn1.Attributes.Add("onclick", "javascript:return confirm('你确认要取消推荐吗')");
            else
                btn1.Attributes.Add("onclick", "javascript:return confirm('你确认要推荐吗')");
        }
    }
    public string GetNewTitle(string Title, string strID)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "Agent/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        return Restr;
    }
}
