﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;
using System.Data.SqlClient;

public partial class admin_Agent_WillAgentEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        try
        {
            if (Request.QueryString["ID"] != null)
            {
                if (Request.QueryString["UserID"] != null)
                    this.HiddUserID.Value = Request.QueryString["UserID"].ToString();
                int id = int.Parse(Request.QueryString["ID"].ToString());
                IWillAgent RWill = new RWillAgent();
                TWillAgent TWill = RWill.GateItem(id);
                txtName.Text = TWill.Name;
                txtTitle.Text = TWill.Title;
                if (TWill.AgentType != null)
                {
                    string Sql = "SELECT [ParentID] FROM [W_AgentType] WHERE [ID]=" + TWill.AgentType;
                    SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString);
                    SqlCommand cmd = new SqlCommand(Sql, con);
                    using (con)
                    {
                        con.Open();
                        SqlDataReader sr = cmd.ExecuteReader();
                        if (sr.Read())
                        {
                            string ParentID = sr["ParentID"].ToString();
                            sr.Close();
                            con.Close();
                            if (ParentID.Equals("0"))
                            {
                                lstParentType.SelectedValue = TWill.AgentType.ToString();
                            }
                            else
                            {
                                lstParentType.SelectedValue = ParentID;
                                RSincereAgent SonInfo = new RSincereAgent();
                                DataTable dt = SonInfo.GetSonType(int.Parse(ParentID));
                                if (dt != null)
                                {
                                    lstSonType.DataSource = dt;
                                    lstSonType.DataTextField = "Name";
                                    lstSonType.DataValueField = "ID";
                                    lstSonType.DataBind();
                                    lstSonType.SelectedValue = TWill.AgentType.ToString();
                                }
                            }
                        }
                        else
                             lstParentType.SelectedValue = TWill.AgentType.ToString();
                    }
                }
                radlValidity.SelectedValue = TWill.Validity;
                txtCount.Text = TWill.Count.ToString();
                txtInvestment.Text = TWill.Investment;
                txtPrice.Text = TWill.Price;
                txtStandard.Text = TWill.Standard;
                Detail.Value = TWill.Detail;
                ImgUrl1.Value = TWill.Picture;
                ImgUrl.Src = TWill.Picture;

            }
        }
        catch (Exception ex)
        { 
        
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            if (Request.Form["province"] != null && Request.Form["province"] != "")
                myValue += Request.Form["province"] + ",";
            if (Request.Form["city"] != null && Request.Form["city"] != "")
                myValue += Request.Form["city"] + ",";
            TWillAgent TWill = new TWillAgent();
            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TWill.ID = id;
            }
            TWill.Name = txtName.Text;
            TWill.Title = txtTitle.Text.Trim();
            if (lstSonType.SelectedValue!="")
            {
                TWill.AgentType = int.Parse(lstSonType.SelectedValue);
            }
            else
            {
                TWill.AgentType = int.Parse(lstParentType.SelectedValue);
            }
            TWill.Validity = radlValidity.SelectedValue;
            if (Common.CheckNum(txtCount.Text.Trim()))
                TWill.Count = int.Parse(txtCount.Text);
            else
            {
                ShowMessage("产品数量为整数");
                return;
            }
            TWill.Investment = txtInvestment.Text;
            TWill.Price = txtPrice.Text;
            TWill.Standard = txtStandard.Text;
            TWill.Detail = Detail.Value;
            TWill.Picture = ImgUrl1.Value;
            IWillAgent RWill = new RWillAgent();
            RWill.Update(TWill);
            ShowMessage("商机发布成功！", "Agent/WillAgentList.aspx");
        }
        catch (Exception ex)
        {

            ShowMessage("商机发布失败!", "Agent/WillAgentList.aspx");
        }
    }
    protected void btnBack_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='WillAgentList.aspx'</script>");
    }



    protected void lstParentType_SelectedIndexChanged(object sender, EventArgs e)
    {
        int ParentID = int.Parse(lstParentType.SelectedValue);
        RSincereAgent SonInfo = new RSincereAgent();
        DataTable dt = SonInfo.GetSonType(ParentID);
        if (dt != null)
        {
            lstSonType.DataSource = dt;
            lstSonType.DataTextField = "Name";
            lstSonType.DataValueField = "ID";
            lstSonType.DataBind();
        }
    }
}
