﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;

public partial class admin_Agent_WillAgentList : BasePage
{

    private int pageSize = 12;//这里设置分页条数
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    #region 绑定数据方法
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_WillAgent,W_AgentType";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "W_WillAgent.*,W_AgentType.Name as TypeName";
        PageNo1.PageSize = pageSize;
        string strWhere = "W_AgentType.ID=W_WillAgent.AgentType";
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdWillAgent.DataSource = dt.DefaultView;
            grdWillAgent.DataBind();
        }
        else {
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " and W_WillAgent.Verify=1";
                        break;
                    case "2":
                        strWhere += " and W_WillAgent.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    case "3":
                        strWhere += " and W_WillAgent.Recommend=1";
                        this.Label4.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            else
            {
                this.Label1.CssClass = "pl";
            }
            string TitleName = txtTitleName.Text.Trim();
            if (TitleName != "")
                strWhere += " and W_WillAgent.Title like '%" + TitleName + "%'";

            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdWillAgent.DataSource = dt.DefaultView;
            grdWillAgent.DataBind();
        }
    }
    #endregion
   
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            AgentTypeBind();
            Bind();
        }
    }

    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }

    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        TWillAgent TWill = new TWillAgent();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TWill.ID = int.Parse(Content.Substring(0, index));
        TWill.Verify = int.Parse(Content.Substring(index + 1));
        IWillAgent RWill = new RWillAgent();
        RWill.UpdateVerify(TWill);
        Bind();
    }

    protected void grdWillAgent_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            //LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            //LinkButton btn1 = (LinkButton)e.Row.FindControl("lbtnUpdateRecommend");
            //if (btn.Text == "已审")
            //    btn.Attributes.Add("onclick", "javascript:return confirm('你要取消审核吗？')");
            //else
            //    btn.Attributes.Add("onclick", "javascript:return confirm('你要让该会员通过审核吗？请注意该会员是否满足该等级的条件要求！通过审核后,将开通该会员服务功能？')");
            //if (btn1.Text == "推荐")
            //    btn1.Attributes.Add("onclick", "javascript:return confirm('你确认要取消推荐吗')");
            //else
            //    btn1.Attributes.Add("onclick", "javascript:return confirm('你确认要推荐吗')");
        }
    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdWillAgent.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdWillAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int id = Convert.ToInt32(grdWillAgent.DataKeys[i].Value);
                IWillAgent RWill = new RWillAgent();
                int m = RWill.Delete(id);
            }
        }
        Bind();
    }

    protected void lbtnUpdateRecommend_Command(object sender, CommandEventArgs e)
    {
        TWillAgent TWill = new TWillAgent();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TWill.ID = int.Parse(Content.Substring(0, index));
        TWill.Recommend = Convert.ToBoolean(Content.Substring(index + 1));
        IWillAgent RWill = new RWillAgent();
        RWill.UpdateRecommend(TWill);
        Bind();
    }

    protected void grdWillAgent_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView gv = (GridView)sender;
        int newPageIndex = 0;
        if (-2 == e.NewPageIndex)
        {
            TextBox tb = null;
            GridViewRow gvr = gv.BottomPagerRow;
            if (gvr != null)
            {
                tb = (TextBox)gvr.FindControl("txtNum");

            }
            if (tb != null)
            {
                newPageIndex = int.Parse(tb.Text) - 1;
            }
        }
        else
        {
            newPageIndex = e.NewPageIndex;
        }
        newPageIndex = newPageIndex <= 0 ? 0 : newPageIndex;
        this.grdWillAgent.PageIndex = newPageIndex;
        //分页后重新绑定数据源
        Bind();
    }

    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        IWillAgent rs = new RWillAgent();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = rs.Delete(id);
        Bind();
    }
   
    private void AgentTypeBind()
    {
        dropAgentType.Items.Add(new ListItem("--请选择类目--", "0"));
        RAgentType RAgent = new RAgentType();
        DataTable dt = RAgent.GetAllParentItem();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {

                dropAgentType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

            }
        }
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = " W_AgentType.ID=W_WillAgent.AgentType";
        if (dropAgentType.SelectedValue.Equals("0"))
        {

        }
      
        else if ((!dropAgentType.SelectedValue.Equals("0")))
        {
            strWhere += " AND W_WillAgent.AgentType=" + dropAgentType.SelectedValue;
        }
        string TitleName = txtTitleName.Text.Trim();
        if (TitleName != "")
            strWhere += " and W_WillAgent.Title like '%" + TitleName + "%'";
        Session["strWhere"] = strWhere;
        string strURl2 = Request.RawUrl;
        strURl2 = strURl2.Substring(0, strURl2.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl2);
        Response.End();
    }

  
    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "3")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdWillAgent.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdWillAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(grdWillAgent.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Agent/WillAgentList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_WillAgent", "Verify=3", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Agent/WillAgentList.aspx");
        }
    }
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdWillAgent.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdWillAgent.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(grdWillAgent.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Agent/WillAgentList.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_WillAgent", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Agent/WillAgentList.aspx");
        }
    }
}
