﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using Area;
using Base;

public partial class admin_Area_AreaList : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        int ParentID = 0;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "";
        if (Request.QueryString["page"] != null)
        {
            if (Session["strWhere"] != null)
            {
                strWhere = Session["strWhere"].ToString();
            }
            else
            {
                strWhere = "1=1";
            }
            PageNo1.Strurl = strURl;
            PageNo1.FldName = "Sequence";
            PageNo1.Table = "W_Area";
            PageNo1.StrGetFields = "*";
            PageNo1.PageSize = pageSize;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            DataTable dt = PageNo1.BindView();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "<font color='red'>暂无数据！</font>";
            }
            else
            {
                lblMessage.Visible = false;
            }
            grdArea.DataSource = dt.DefaultView;
            grdArea.DataBind();
        }
        else
        {
            strWhere = "1=1";
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                ParentID = int.Parse(Request.QueryString["ParentID"]);
            }
            strWhere += " and ParentID=" + ParentID;
            PageNo1.Strurl = strURl;
            PageNo1.FldName = "Sequence";
            PageNo1.Table = "W_Area";
            PageNo1.StrGetFields = "*";
            PageNo1.PageSize = pageSize;
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindView();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "<font color='red'>暂无数据！</font>";
            }
            else
            {
                lblMessage.Visible = false;
            }
            grdArea.DataSource = dt.DefaultView;
            grdArea.DataBind();
        }
    }
    protected void btnAreaAdd_Click(object sender, EventArgs e)
    {
        if (pnlArea.Visible)
            pnlArea.Visible = false;
        else
            pnlArea.Visible = true;
    }
    protected void grdArea_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int id = int.Parse(grdArea.DataKeys[e.RowIndex].Value.ToString());
        string name = ((TextBox)grdArea.Rows[e.RowIndex].FindControl("txtName")).Text;
        TArea TArea = new TArea();
        TArea.ID = id;
        TArea.Name = name;
        IArea RArea = new RArea();
        RArea.Update(TArea);
        grdArea.EditIndex = -1;
        Bind();
    }
    /// <summary>
    /// 排序
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        foreach (GridViewRow rows in this.grdArea.Rows)
        {
            TextBox txt = rows.FindControl("txtSequence") as TextBox;
            System.Web.UI.WebControls.Label lbid = rows.FindControl("Lb_id") as System.Web.UI.WebControls.Label;
            int txtd =0;
            if (GetRequest.isNum(txt.Text.ToString()))
                txtd = Convert.ToInt32(txt.Text.ToString());
            int lbxid = Convert.ToInt32(lbid.Text.ToString());
            IArea RArea = new RArea();
            RArea.UpdateSequence(txtd, lbxid);
        }
        Bind();
    }
    protected void grdArea_RowEditing(object sender, GridViewEditEventArgs e)
    {
        grdArea.EditIndex = e.NewEditIndex;
        Bind();
    }
    protected void grdArea_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        grdArea.EditIndex = -1;
        Bind();
    }
    protected void grdArea_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdArea.DataKeys[e.RowIndex].Value.ToString());
        IArea RArea = new RArea();
        RArea.Delete(id);
        Bind();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        IArea RArea = new RArea();
        for (int i = 0; i < grdArea.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdArea.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdArea.DataKeys[i].Value.ToString());
                RArea.Delete(id);
            }
        }
        Bind();
    }

    public static bool WriteFile()
    {
        string sPath = AppDomain.CurrentDomain.BaseDirectory.ToString() + "js\\area.js";
        System.Text.Encoding code = System.Text.Encoding.GetEncoding("gb2312");
        // 读取模板文件 
        StreamWriter sw = null;
        // 替换内容 
        // 这时,模板文件已经读入到名称为str的变量中了 
        string str = Base.CreateJS.CreateArea(); //模板页中的ShowArticle 
        // 写文件 
        try
        {
            sw = new StreamWriter(sPath, false, code);
            sw.Write(str);

            sw.Flush();
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
            HttpContext.Current.Response.End();
        }
        finally
        {
            sw.Close();
        }
        return true;

    }
    protected void ButJS_Click(object sender, EventArgs e)
    {
        bool b = WriteFile();
        if (b == true)
        {
            Response.Write("<script>alert('生成成功！');</script>");
        }
        else
        {
            Response.Write("<script>alert('生成失败！');</script>");
        }
    }
    /// <summary>
    /// 添加地区信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnInsert_Click(object sender, EventArgs e)
    {
        try
        {
            string ParentID = "0";
            string Restr = "";
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                ParentID = Request.QueryString["ParentID"];
            }
            TArea TArea = new TArea();
            TArea.ParentID = int.Parse(ParentID);
            if (txtName.Text != "")
                TArea.Name = txtName.Text;
            else
                Restr += "地区名称、";
            if (txtSequence.Text != "")
                TArea.Sequence = int.Parse(txtSequence.Text);
            else
                Restr += "排序";
            if (Restr == "")
            {
                IArea RArea = new RArea();
                RArea.Insert(TArea);
                ShowMessage("地区添加成功！", "Area/AreaList.aspx?ParentID=" + ParentID);
            }
            else
            {
                lblError.Visible = true;
                lblError.Text = Restr + "填写有误！";
            }

        }
        catch (Exception ex)
        {

            ShowMessage("地区添加失败!", "Area/AreaList.aspx");
        }
    }
    /// <summary>
    /// 取消添加地区信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnReturn_Click(object sender, EventArgs e)
    {
        pnlArea.Visible = false;
    }
    protected void grdArea_RowDataBound(object sender, GridViewRowEventArgs e)
    {

    }
    protected void grdArea_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {

    }
    protected void grdArea_RowDataBound1(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
