﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Solely;

public partial class admin_Basic_Registr : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!this.IsPostBack)
        {
            bindVipGrade();
            bind();
        }
    }

    /// <summary>
    /// 绑定会员等级
    /// </summary>
    private void bindVipGrade()
    {
        VipGrade.IVipGrade Grade = new VipGrade.RVipGrade();
        DataSet ReTable = Grade.GetDataTable();
        DataView dv = ReTable.Tables[0].DefaultView;
        this.DrpVipGrade.DataSource = dv;
        this.DrpVipGrade.DataTextField = ReTable.Tables[0].Columns["Name"].ToString();
        this.DrpVipGrade.DataValueField = ReTable.Tables[0].Columns["ID"].ToString();
        this.DrpVipGrade.DataBind();
    }


    private void bind()
    {
        UserRegistr RegItem = UserRegistr.GateItem();
        this.isRegister.SelectedValue = RegItem.isRegister.ToString();
        this.ManageRegister.SelectedValue = RegItem.ManageRegister.ToString();
        this.isCode.SelectedValue = RegItem.isCode.ToString();
        this.isQuestion.SelectedValue = RegItem.isQuestion.ToString();
        this.Question.Text = RegItem.Question.ToString();
        this.Answer.Text = RegItem.Answer.ToString();
        // this.BannedIP.Text = RegItem.BannedIP.ToString();
        this.BannedUser.Text = RegItem.BannedUser.ToString();
        this.Code_Login.SelectedValue = RegItem.Code_Login.ToString();
        this.Code_GetPass.SelectedValue = RegItem.Code_GetPass.ToString();
        this.GetPass_Count.Text = RegItem.GetPass_Count.ToString();
        this.Minimum.Text = RegItem.Minimum.ToString();
        this.Longest.Text = RegItem.Longest.ToString();
        this.MinTimeRegister.Text = RegItem.MinTimeRegister.ToString();
        this.Gocipher_Method.SelectedValue = RegItem.Gocipher_Method.ToString();
        this.OnlyUser_Email.SelectedValue = RegItem.OnlyUser_Email.ToString();
        this.ToMessage.SelectedValue = RegItem.ToMessage.ToString();
        this.MessageInfo.Text = RegItem.MessageInfo.ToString();
        this.ToEmail.SelectedValue = RegItem.ToEmail.ToString();
        this.EmailInfo.Text = RegItem.EmailInfo.ToString();
        this.DrpVipGrade.SelectedValue = RegItem.VipGrade.ToString();
        this.MessageTitle.Text = RegItem.MessageTitle;
        this.EmailTitle.Text = RegItem.EmailTitle;
    }

    protected void BtnSave_Click(object sender, EventArgs e)
    {
        try
        {
            UserRegistr RegItem = UserRegistr.GateItem();
            RegItem.isRegister = Convert.ToBoolean(this.isRegister.SelectedValue.ToString());
            RegItem.ManageRegister = Convert.ToBoolean(this.ManageRegister.SelectedValue.ToString());
            RegItem.VipGrade = int.Parse(this.DrpVipGrade.SelectedValue.ToString());
            RegItem.isCode = Convert.ToBoolean(this.isCode.SelectedValue.ToString());
            RegItem.isQuestion = Convert.ToBoolean(this.isQuestion.SelectedValue.ToString());
            RegItem.Question = this.Question.Text.ToString();
            RegItem.Answer = this.Answer.Text.ToString();
            // RegItem.BannedIP= "";
            RegItem.BannedUser = this.BannedUser.Text.ToString();
            RegItem.Code_Login = Convert.ToBoolean(this.Code_Login.SelectedValue.ToString());
            RegItem.Code_GetPass = Convert.ToBoolean(this.Code_GetPass.SelectedValue.ToString());
            RegItem.GetPass_Count = Convert.ToInt32(this.GetPass_Count.Text.ToString());
            RegItem.Minimum = Convert.ToInt32(this.Minimum.Text.ToString());
            RegItem.Longest = Convert.ToInt32(this.Longest.Text.ToString());
            RegItem.MinTimeRegister = Convert.ToInt32(this.MinTimeRegister.Text.ToString());
            RegItem.Gocipher_Method = Convert.ToInt32(this.Gocipher_Method.SelectedValue.ToString());
            RegItem.OnlyUser_Email = Convert.ToBoolean(this.OnlyUser_Email.SelectedValue.ToString());
            RegItem.ToMessage = Convert.ToBoolean(this.ToMessage.SelectedValue.ToString());
            RegItem.MessageInfo = this.MessageInfo.Text.ToString();
            RegItem.ToEmail = Convert.ToBoolean(this.ToEmail.SelectedValue.ToString());
            RegItem.EmailInfo = this.EmailInfo.Text.ToString();
            RegItem.MessageTitle = this.MessageTitle.Text;
            RegItem.EmailTitle = this.EmailTitle.Text;
                
            RegItem.Update(RegItem);
            ShowMessage("注册表单保存成功!", "Basic/Registr.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("注册表单保存失败!", "Basic/Registr.aspx");
        }
    }
}
