﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Basic_SetupUpload : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Base.XMLProcess xp = new Base.XMLProcess("xml/ImageWater.xml");
            this.txtFolder.Text = xp.Read("/param/folder");
            this.txtFiletype.Text = xp.Read("/param/filetype");
            this.txtFilesize.Text = xp.Read("/param/filesize");
            this.txtThumbsize1.Text = xp.Read("/param/thumbWidth");
            this.txtThumbsize2.Text = xp.Read("/param/thumbHeight");
            this.radIsWatermark.SelectedValue = xp.Read("/param/iswatermark");
            this.radWatemarktype.SelectedValue = xp.Read("/param/watemarktype");
            this.txtImgurl.Text = xp.Read("/param/imgurl");
            this.txtFonttext.Text = xp.Read("/param/fonttext");
            this.drpFontfamily.SelectedValue = xp.Read("/param/fontfamily");
            this.drpFontcolor.SelectedValue = xp.Read("/param/fontcolor");
            this.drpFontsize.SelectedValue = xp.Read("/param/fontsize");
            this.txtTrans.Text = xp.Read("/param/trans");
            this.txtQuality.Text = xp.Read("/param/quality");
            this.radPos.SelectedValue = xp.Read("/param/pos");
        }
    }

    /// <summary>
    ///  保存会员修改的信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void butSave_Click(object sender, EventArgs e)
    {
        try
        {
            Base.XMLProcess xp = new Base.XMLProcess("xml/ImageWater.xml");
            string str = "img/";
            if (txtFolder.Text.Trim() != "")
                str = this.txtFolder.Text.Trim();
            xp.Update("/param/folder", str);
            if (txtFiletype.Text.Trim() == "")
            {
                xp.Update("/param/filetype", "jpg|gif|png");
            }
            else
            {
                xp.Update("/param/filetype", this.txtFiletype.Text.Trim());
            }
            xp.Update("/param/filesize", this.txtFilesize.Text.Trim());

            if (Base.Common.CheckNum(this.txtThumbsize1.Text.Trim().ToString()))
                xp.Update("/param/thumbWidth", this.txtThumbsize1.Text.Trim());
            else
                xp.Update("/param/thumbWidth", "150");

            if (Base.Common.CheckNum(this.txtThumbsize2.Text.Trim().ToString()))
                xp.Update("/param/thumbHeight", this.txtThumbsize2.Text.Trim());
            else
                xp.Update("/param/thumbHeight", "150");
            xp.Update("/param/iswatermark", this.radIsWatermark.SelectedValue);
            xp.Update("/param/watemarktype", this.radWatemarktype.SelectedValue);
            xp.Update("/param/imgurl", this.txtImgurl.Text.Trim());
            xp.Update("/param/fonttext", this.txtFonttext.Text.Trim());
            xp.Update("/param/fontfamily", this.drpFontfamily.SelectedValue);
            xp.Update("/param/fontcolor", this.drpFontcolor.SelectedValue);
            xp.Update("/param/fontsize", this.drpFontsize.SelectedValue);
            xp.Update("/param/trans", this.txtTrans.Text.Trim());
            xp.Update("/param/quality", this.txtQuality.Text.Trim());
            xp.Update("/param/pos", this.radPos.SelectedValue);
            ShowMessage("修改成功！", "Basic/SetupUpload.aspx");
        }
        catch( Exception  ex )
        {
            ShowMessage("修改失败！", "Basic/SetupUpload.aspx");
        }
    }
}
