﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TradeSettings;

public partial class admin_Basic_TradeSettings : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        ITradeSettings RTrade = new RTradeSettings();
        TTradeSettings TTrade = RTrade.GateItem("供应");
        radlisADD.SelectedValue = TTrade.isADD.ToString();
        radlisEdit.SelectedValue = TTrade.isEdit.ToString();
        txtMark.Text = TTrade.Mark.ToString();
        radlisEmail.SelectedValue = TTrade.isEmail.ToString();
        txtEmailTitle.Text = TTrade.EmailTitle;
        txtEmailInfo.Text = TTrade.EmailInfo;
        radlisSMS.SelectedValue = TTrade.isSMS.ToString();
        txtSMSTitle.Text = TTrade.SMSTitle;
        txtSMSContext.Text = TTrade.SMSInfo;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string myValue = dropTradeType.SelectedValue;
        try
        {
            TTradeSettings TTrade = new TTradeSettings();
            TTrade.TradeType = myValue;
            TTrade.isADD = Convert.ToBoolean(radlisADD.SelectedValue);
            TTrade.isEdit = Convert.ToBoolean(radlisEdit.SelectedValue);
            TTrade.Mark = int.Parse(txtMark.Text);
            TTrade.isEmail = Convert.ToBoolean(radlisEmail.SelectedValue);
            TTrade.EmailTitle = txtEmailTitle.Text;
            TTrade.EmailInfo = txtEmailInfo.Text;
            TTrade.isSMS = Convert.ToBoolean(radlisSMS.SelectedValue);
            TTrade.SMSTitle = txtSMSTitle.Text;
            TTrade.SMSInfo = txtSMSContext.Text;
            ITradeSettings RTrade = new RTradeSettings();
            RTrade.Update(TTrade);
            ShowMessage("网站配置保存成功！", "Basic/TradeSettings.aspx");
        }
        catch (Exception ex)
        {

            ShowMessage(ex.Message);
        }
    }
    protected void dropTradeType_SelectedIndexChanged(object sender, EventArgs e)
    {
        string myValue = dropTradeType.SelectedValue;
        ITradeSettings RTrade = new RTradeSettings();
        TTradeSettings TTrade = RTrade.GateItem(myValue);
        radlisADD.SelectedValue = TTrade.isADD.ToString();
        radlisEdit.SelectedValue = TTrade.isEdit.ToString();
        txtMark.Text = TTrade.Mark.ToString();
        radlisEmail.SelectedValue = TTrade.isEmail.ToString();
        txtEmailTitle.Text = TTrade.EmailTitle;
        txtEmailInfo.Text = TTrade.EmailInfo;
        radlisSMS.SelectedValue = TTrade.isSMS.ToString();
        txtSMSTitle.Text = TTrade.SMSTitle;
        txtSMSContext.Text = TTrade.SMSInfo;
    }
}
