﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using WebBasicInfo;
using Base;
using System.IO;
using Base.Core;
public partial class admin_Basic_WebBasic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }


    /// <summary>
    /// 读取网站基本信息
    /// </summary>
    private void Bind()
    {
        IWebBasicInfo RWeb = new RWebBasicInfo();
        TWebBasicInfo TWeb = RWeb.GateItem();
        txtStopReadme.Text = TWeb.StopReadme;
        radlState.SelectedValue = TWeb.State.ToString();
        txtWebName.Text = TWeb.WebName;
        txtWebUrl.Text = TWeb.WebURL;
        //txtCatalog.Text = TWeb.Catalog;
        radlisBlog.SelectedValue = TWeb.isBlog.ToString();
        //radlisSecondUrl.SelectedValue = TWeb.isSecondURL.ToString();
        radlisForum.SelectedValue = TWeb.isForum.ToString();
        txtCopyright.Text = TWeb.Copyright;
        txtRecord.Text = TWeb.Record;
        ImgUrl.Src = TWeb.WebLOGO;
        ImgUrl1.Value = TWeb.WebLOGO;
	    drpRewrite.SelectedValue = TWeb.Rewrite;
        txtCorporationName.Text = TWeb.CorporationName;
        txtSystemTel.Text = TWeb.SystemTel;
        txtHotTel.Text = TWeb.HotTel;
        txtFaxTel.Text = TWeb.FaxTel;
        txtAddress.Text = TWeb.Address;
        txtPostalCode.Text = TWeb.PostalCode;
        txtBankAccount.Text = TWeb.BankAccount;
        txtBankName.Text = TWeb.BankName;
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            TWebBasicInfo TWeb = new TWebBasicInfo();
            //基本信息
            TWeb.State = int.Parse(radlState.SelectedValue);
            TWeb.StopReadme = txtStopReadme.Text.Trim();

            if (txtWebName.Text.Trim().Equals(string.Empty))
                Restr += "网站名称，";
            else
                TWeb.WebName = txtWebName.Text.Trim();
            if (txtWebUrl.Text.Trim().Equals(string.Empty))
            {
                Restr += "网站网址，";
            }
            else 
            {
                TWeb.WebURL = txtWebUrl.Text.Trim();
            }
            TWeb.Catalog = "admin/";
            TWeb.isSecondURL = false;
            TWeb.Copyright = txtCopyright.Text;
            TWeb.Record = txtRecord.Text;
            TWeb.WebLOGO = this.ImgUrl1.Value.ToString();
            //公司信息
            TWeb.CorporationName = txtCorporationName.Text.Trim();
            TWeb.SystemTel = txtSystemTel.Text.Trim();
            TWeb.HotTel = txtHotTel.Text.Trim();
            TWeb.FaxTel = txtFaxTel.Text.Trim();
            TWeb.Address = txtAddress.Text.Trim();
            TWeb.PostalCode = txtPostalCode.Text.Trim();
            TWeb.BankAccount = txtBankAccount.Text.Trim();
            TWeb.BankName = txtBankName.Text.Trim();
            TWeb.Rewrite = drpRewrite.SelectedValue;
            IWebBasicInfo RWeb = new RWebBasicInfo();
            if (!Restr.Trim().Equals(string.Empty))
                Restr = Restr.Substring(0, Restr.Length - 1);
            if (Restr.Trim().Equals(string.Empty))
            {
                RWeb.UpdateSystemInfo(TWeb);
                WebConfig config = ((WebConfig)Application["WebConfig"]);
                WebConfig config1 = new WebConfig();
                //config1.Rewrite = drpRewrite.SelectedValue;
                //config1.WebLogo = this.ImgUrl1.Value.ToString();
                //config1.WebURL = txtWebUrl.Text.Trim();
                ShowMessage("网站配置保存成功！", "Basic/WebBasic.aspx");
                return;
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage("网站配置保存失败!", "Basic/WebBasic.aspx");
        }
    }
}
