﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Consultative;
using Base;

public partial class admin_Consultative_ConsultativeAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "B1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        dropTypeID.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
        dropType.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt = RCon.GetDataTable();

        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {

                dropTypeID.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

            }
        }
    }
    protected void btnServer_Click(object sender, EventArgs e)
    {
        try
        {
            TConsultative TCon = new TConsultative();
            string myValue = "";
            TCon.Title = txtTitle.Text;
            if (dropTypeID.SelectedValue == "0")
            {
                ShowMessage("请选择所属类别！");
                return;
            }
            else
            {
                if (dropType.SelectedValue == "0")
                    TCon.TypeID = int.Parse(this.dropTypeID.SelectedValue);
                else
                    TCon.TypeID = int.Parse(this.dropType.SelectedValue);
            }


            TCon.IsComment = false;
            TCon.IsHotspot = false;
            TCon.IsTop = false;
            TCon.IsRecommend = false;
            if (chklAttribute.Items[0].Selected == true)
            {
                TCon.IsRecommend = true;
            }
            if (chklAttribute.Items[1].Selected == true)
            {
                TCon.IsTop = true;
            }
            if (chklAttribute.Items[2].Selected == true)
            {
                TCon.IsHotspot = true;
            }
            if (chklAttribute.Items[3].Selected == true)
            {
                TCon.IsComment = true;
            }
            TCon.KeyWord = txtKeyWord.Text;
            TCon.Author = txtAuthor.Text;
            TCon.Reading = txtReading.Text;
            TCon.ClickCount = txtClickCount.Text;
            TCon.Origin = txtOrigin.Text;
            TCon.Picture = ImgUrl1.Value;
            if (chkChangeDirectionLink.Checked)
            {
                TCon.ChangeDirectionLink = text.Value;
                TCon.Detail = "";
            }
            else
            {
                TCon.ChangeDirectionLink = "";
                string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
                Temp = GetRequest.WipeScript(Temp);
                TCon.Detail = Temp;
            }
            if (txtAddDate.Text != "")
            {
                if (GetRequest.isDataTime(txtAddDate.Text))
                    TCon.AddDate = Convert.ToDateTime(txtAddDate.Text + " " + DateTime.Now.TimeOfDay);
                else
                    TCon.AddDate = DateTime.Now;
            }
            else
                TCon.AddDate = DateTime.Now;
            if (GetRequest.isNum(txtClickCount.Text))
                TCon.ClickCount = txtClickCount.Text;
            else
                TCon.ClickCount = "0";
            IConsultative RCon = new RConsultative();
            RCon.Insert(TCon);
            ShowMessage("添加商业资讯信息成功！", "Consultative/ConsultativeManage.aspx");

        }
        catch (Exception ex)
        {

            ShowMessage("添加商业资讯信息失败！", "Consultative/ConsultativeManage.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtTitle.Text = string.Empty;
        dropTypeID.SelectedValue = "0";
        for (int i = 0; i < chklAttribute.Items.Count; i++)
        {

            this.chklAttribute.Items[i].Selected = false;
        }
        txtKeyWord.Text = string.Empty;
        txtAuthor.Text = string.Empty;
        txtReading.Text = string.Empty;
        txtOrigin.Text = string.Empty;
        ImgUrl1.Value = string.Empty;
        ImgUrl.Src = string.Empty;
        text.Value = string.Empty;
        Detail.Value = string.Empty;
        txtAddDate.Text = string.Empty;
        txtClickCount.Text = string.Empty;
    }

    protected void dropTypeID_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            dropType.Items.Clear();
            dropType.Items.Add(new ListItem("--请选择类目--", "0"));
            IConsultativeType RCon = new RConsultativeType();
            DataTable dt = RCon.GetDataTable(int.Parse(dropTypeID.SelectedValue));
            if (dt.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt.Rows)
                {

                    dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
}

