﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Consultative;
using Base;

public partial class Admin_Consultative_ConsultativeDigg :BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "B1");
        if (!IsPostBack)
        {
            Bind();
            dropTypeInfo();
        }
    }

    private void Bind()
    {
        string labletype = "";
        string strWhere = "1=1";
        if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
        {
            labletype =Base.GetRequest.Filter(Request.QueryString["TypeID"].ToString());
            strWhere += " and TypeID=" + labletype;
        }
        pbind(strWhere, Pageindex);
    }
    #region 获取数据并分页
    private void pbind(string strWhere, int Pageindex)
    {
        string table = "W_ConsultativeType as b  Right  JOIN W_Consultative as a  ON a.TypeID = b.ID ";
        string select = "a.*,b.Name,b.ID";
        strWhere += " AND (CountUp<>0 OR CountDown<>0) ";
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "a. CountUp", select, pageSize, Pageindex, 0);
        if (dt.Rows.Count == 0)
        {

        }
        DataTable dtb = Base.PageList.GetDataTable(strWhere, table);
        PageCount = Convert.ToInt32(dtb.Rows[0]["Total"]);
        this.txt_pageCount.Text = PageCount.ToString();
        if (Pageindex == 1)
        {
            this.btn_pageFirst.Enabled = false;
            this.btn_pageLast.Enabled = false;
        }
        else
        {
            this.btn_pageFirst.Enabled = true;
            this.btn_pageLast.Enabled = true;
        }
        if (Pageindex == (PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1))
        {
            this.btn_pageNext.Enabled = false;
            this.btn_pageFoot.Enabled = false;
        }
        else
        {
            this.btn_pageNext.Enabled = true;
            this.btn_pageFoot.Enabled = true;
        }
        if (PageCount == 0)
        {
            this.btn_pageNext.Enabled = false;
            this.btn_pageFoot.Enabled = false;
        }
        this.txt_begin.Text = Pageindex.ToString();
        this.txt_pageAll.Text = Convert.ToString((PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1));
        this.txt_PageNum.Text = Pageindex.ToString();

        grdConsultative.DataSource = dt.DefaultView;
        grdConsultative.DataBind();
    }
    #endregion

    #region 分页事件
    protected void btn_pageFirst_Click(object sender, EventArgs e)
    {
        //首页事件
        this.Pageindex = 1;
        Bind();
    }
    protected void btn_pageLast_Click(object sender, EventArgs e)
    {
        //上一页
        this.Pageindex--;
        Bind();
    }
    protected void btn_pageNext_Click(object sender, EventArgs e)
    {
        //下一页
        this.Pageindex++;
        Bind();
    }
    protected void btn_pageFoot_Click(object sender, EventArgs e)
    {
        //末页
        this.Pageindex = PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1;
        Bind();
    }
    protected void btn_go_Click(object sender, EventArgs e)
    {
        //跳到指定的页
        string txtNumber = this.txt_PageNum.Text.ToString().Trim();
        int index = 1;
        if (Base.Common.CheckNum(txtNumber))
        {
            index = Convert.ToInt32(txtNumber);
            if (index >= 1 && index <= (PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1))
            {
                Pageindex = index;
                Bind();
            }
            else
            {
                Pageindex = 1;
                this.txt_PageNum.Text = "输入错误";
            }
        }
        else
        {
            Pageindex = 1;
            this.txt_PageNum.Text = "输入错误";
        }
    }
    #endregion

    protected void grdConsultative_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {

            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");

            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");

        }     
    }

    protected void btnsubmit_Click(object sender, EventArgs e)
    {
        string strWhere = " 1=1";
        string Key =Base.GetRequest.Filter(txtKeyWord.Text.Trim());
        if (Key!="")
        {
            strWhere += " AND [Title] like '%" + Key + "%'";
        }
        if (dropType.SelectedIndex!=0)
        {
            strWhere += " AND TypeID=" + dropType.SelectedValue;
        }

        pbind(strWhere, 1);
    }

    ///<summary>
    /// 行业资讯类别绑定
    ///</summary>
    private void dropTypeInfo()
    {
        dropType.Items.Add(new ListItem("--+请选择所属类别+--", ""));
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt = RCon.GetDataTable();

        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    }

    /// <summary>
    /// 处理标题
    /// </summary>
    /// <param name="Title"></param>
    /// <param name="IsTop"></param>
    /// <param name="IsRecommend"></param>
    /// <param name="IsHotspot"></param>
    /// <param name="Picture"></param>
    /// <returns></returns>
    public string GetNewTitle(string Title, string strID, string IsTop, string IsRecommend, string IsHotspot, string Picture)
    {
        string Restr = "<a href=\"/News/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        if (IsTop.Equals("True"))
        {
            Restr += "<font color=\"red\"> 顶</font>";
        }
        if (IsRecommend.Equals("True"))
        {
            Restr += "<font color=\"green\"> 荐</font>";
        }
        if (IsHotspot.Equals("True"))
        {
            Restr += "<font color=\"Purple\"> 幻</font>";
        }
        if (Picture != "")
        {
            Restr += "<font color=\"red\"> 图</font>";
        }
        return Restr;
    }
}
