﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Consultative;
using Base;

public partial class admin_Consultative_ConsultativeEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
        // Upfile1.reStr = this.showview;
    }

    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"]);
        if (Request.QueryString["UserID"] != null)
            this.HiddUserID.Value = Request.QueryString["UserID"].ToString();
        IConsultative RCon = new RConsultative();
        TConsultative TCon = RCon.GateItem(id);      //绑定W_ Consultative表
        this.txtTitle.Text = TCon.Title;
        this.txtReading.Text = TCon.Reading;
        this.txtOrigin.Text = TCon.Origin;
        if (TCon.ChangeDirectionLink != "")
        {
            chkChangeDirectionLink.Checked = true;
            text.Disabled = false;
            this.text.Value = TCon.ChangeDirectionLink;
            rowTests.Style.Add("display", "none");

        }
        else
        {
            rowTests.Style.Add("display", "block");
        }
        this.Detail.Value = TCon.Detail;
        if (TCon.IsRecommend == true)
        {
            chklAttribute.Items[0].Selected = true;
        }
        if (TCon.IsTop == true)
        {
            chklAttribute.Items[1].Selected = true;
        }
        if (TCon.IsHotspot == true)
        {
            chklAttribute.Items[2].Selected = true;
        }
        if (TCon.IsComment == true)
        {
            chklAttribute.Items[3].Selected = true;
        }
        this.txtAuthor.Text = TCon.Author;
        this.txtReading.Text = TCon.Reading;
        this.txtKeyWord.Text = TCon.KeyWord;
        this.txtAddDate.Text = TCon.AddDate.ToShortDateString();
        this.txtClickCount.Text = TCon.ClickCount;
        if (TCon.Picture == "")
        {
            //this.ImgUrl1.Value = "../../Images/System/wutu.gif";
            this.ImgUrl.Src = "../../Images/System/wutu1.gif";
        }
        else
        {
            this.ImgUrl1.Value = TCon.Picture;
            this.ImgUrl.Src = TCon.Picture;
        }
        IConsultativeType RCon1 = new RConsultativeType();
        TConsultativeType con = RCon1.GateItem(TCon.TypeID);
        if (con.ParentID != 0)//资讯类别为二级类别
        {
            //绑定父级类别
            dropTypeID.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
            DataTable dt = RCon1.GetDataTable();
            if (dt.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt.Rows)
                {

                    dropTypeID.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
            dropTypeID.SelectedValue = con.ParentID.ToString();

            //根据父级ID查询字类别
            dropType.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
            DataTable dt1 = RCon1.GetDataTable(con.ParentID);
            if (dt1.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt1.Rows)
                {

                    dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
            dropType.SelectedValue = TCon.TypeID.ToString();
        }
        else
        {
            DataTable dt = RCon1.GetDataTable();
            if (dt.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt.Rows)
                {

                    dropTypeID.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
            dropTypeID.SelectedValue = TCon.TypeID.ToString();
            //根据父级ID查询字类别
            dropType.Items.Add(new ListItem("--+请选择所属类别+--", "0"));
            DataTable dt1 = RCon1.GetDataTable(TCon.TypeID);
            if (dt1.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt1.Rows)
                {

                    dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
        }
    }

    protected void btnServer_Click(object sender, EventArgs e)
    {

        try
        {
            int id = int.Parse(Request.QueryString["ID"]);
            TConsultative TCon = new TConsultative();
            TCon.ID = id;
            TCon.Title = txtTitle.Text;
            if (dropTypeID.SelectedValue == "0")
            {
                ShowMessage("请选择所属类别！");
                return;
            }
            else
            {
                if (dropType.SelectedValue == "0")
                    TCon.TypeID = int.Parse(this.dropTypeID.SelectedValue);
                else
                    TCon.TypeID = int.Parse(this.dropType.SelectedValue);
            }

            TCon.IsComment = false;
            TCon.IsHotspot = false;
            TCon.IsTop = false;
            TCon.IsRecommend = false;
            if (chklAttribute.Items[0].Selected == true)
            {
                TCon.IsRecommend = true;
            }
            if (chklAttribute.Items[1].Selected == true)
            {
                TCon.IsTop = true;
            }
            if (chklAttribute.Items[2].Selected == true)
            {
                TCon.IsHotspot = true;
            }
            if (chklAttribute.Items[3].Selected == true)
            {
                TCon.IsComment = true;
            }
            TCon.KeyWord = txtKeyWord.Text;
            TCon.Author = txtAuthor.Text;
            TCon.Reading = txtReading.Text;
            if (GetRequest.isNum(txtClickCount.Text))
                TCon.ClickCount = txtClickCount.Text;
            else
                TCon.ClickCount = "0";
            TCon.Origin = this.txtOrigin.Text;
            TCon.Picture = ImgUrl1.Value;

            if (chkChangeDirectionLink.Checked)
            {
                TCon.ChangeDirectionLink = this.text.Value;
                TCon.Detail = "";
            }
            else
            {
                TCon.ChangeDirectionLink = "";
                string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
                Temp = GetRequest.WipeScript(Temp);
                TCon.Detail = Temp;
            }
            if (txtAddDate.Text != "")
            {
                if (GetRequest.isDataTime(txtAddDate.Text))
                    TCon.AddDate = Convert.ToDateTime(txtAddDate.Text + " " + DateTime.Now.TimeOfDay);
                else
                    TCon.AddDate = DateTime.Now.Date;
            }
            else
                TCon.AddDate = DateTime.Now.Date;
            IConsultative RCon = new RConsultative();
            RCon.Update(TCon);
            ShowMessage("修改商业资讯信息成功！", "Consultative/ConsultativeManage.aspx");

        }
        catch (Exception ex)
        {

            ShowMessage("修改商业资讯信息失败！", "Consultative/ConsultativeManage.aspx");
        }
    }
    private void showview(string str)
    {
        // this.imgPicture.ImageUrl = "~/" + str;
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("ConsultativeManage.aspx");
    }



    protected void dropTypeID_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            dropType.Items.Clear();
            dropType.Items.Add(new ListItem("--请选择类目--", "0"));
            IConsultativeType RCon = new RConsultativeType();
            DataTable dt = RCon.GetDataTable(int.Parse(dropTypeID.SelectedValue));
            if (dt.Rows.Count != 0)
            {
                foreach (DataRow dataRow in dt.Rows)
                {

                    dropType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

                }
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
}
